/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;

public class KeyValueRecord<K, V, ID> {
    static final PropertyAccessor<KeyValueRecord<Object, Object, Object>, Object> KEY_ACCESSOR = PropertyAccessor.fromMethodReference(KeyValueRecord::getKey, KeyValueRecord::setKey);
    public static final PropertyAccessor<KeyValueRecord<Object, Object, Object>, Object> VALUE_ACCESSOR = PropertyAccessor.fromMethodReference(KeyValueRecord::getValue, KeyValueRecord::setValue);
    private RecordId<K, ID> id;
    private K key;
    private V value;
    private boolean persisted = false;

    public KeyValueRecord() {
    }

    public KeyValueRecord(ID id, K key, V value) {
        this.id = new RecordId<K, ID>(id, key);
        this.key = key;
        this.value = value;
    }

    public boolean isNew() {
        return !this.persisted;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void markAsPersisted() {
        this.persisted = true;
    }

    public KeyValueRecord<K, V, ID> setPersisted(boolean persisted) {
        this.persisted = persisted;
        return this;
    }

    public RecordId<K, ID> getId() {
        return this.id;
    }

    public void setId(RecordId<K, ID> id) {
        this.id = id;
        this.persisted = true;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public int footprint() {
        int result = this.id.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }
}

