/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.TriConsumer;

@FunctionalInterface
public interface BeanRelationFixer<E, I> {
    public void apply(E var1, I var2);

    public static <E, I> BeanRelationFixer<E, I> of(BiConsumer<E, I> setter) {
        return BeanRelationFixer.of(setter, (a, b) -> {});
    }

    public static <E, I> BeanRelationFixer<E, I> of(BiConsumer<E, I> setter, BiConsumer<I, E> reverseSetter) {
        return (s, i) -> {
            setter.accept(s, i);
            reverseSetter.accept(i, s);
        };
    }

    public static <E, I, C extends Collection<I>> BeanRelationFixer<E, I> of(BiConsumer<E, C> setter, Function<E, C> getter, Class<? extends C> concreteCollectionType) {
        return BeanRelationFixer.of(setter, getter, () -> (Collection)Reflections.newInstance((Class)concreteCollectionType));
    }

    public static <E, I, C extends Collection<I>> BeanRelationFixer<E, I> of(BiConsumer<E, C> setter, Function<E, C> getter, Supplier<C> collectionFactory) {
        return BeanRelationFixer.of(setter, getter, collectionFactory, (I a, E b) -> {});
    }

    public static <E, I, C extends Collection<I>> BeanRelationFixer<E, I> of(BiConsumer<E, C> setter, Function<E, C> getter, Class<? extends C> concreteCollectionType, BiConsumer<I, E> reverseSetter) {
        return BeanRelationFixer.of(setter, getter, () -> (Collection)Reflections.newInstance((Class)concreteCollectionType), reverseSetter);
    }

    public static <E, I, C extends Collection<I>> BeanRelationFixer<E, I> of(BiConsumer<E, C> setter, Function<E, C> getter, Supplier<C> collectionFactory, BiConsumer<I, E> reverseSetter) {
        return BeanRelationFixer.ofAdapter(setter, getter, collectionFactory, (target, input, collection) -> {
            collection.add(input);
            reverseSetter.accept(input, target);
        });
    }

    public static <E, I, C extends Collection<?>> BeanRelationFixer<E, I> ofAdapter(BiConsumer<E, C> setter, Function<E, C> getter, Supplier<C> collectionFactory, TriConsumer<E, I, C> adapter) {
        return (target, input) -> {
            Collection collection = (Collection)getter.apply(target);
            if (collection == null) {
                collection = (Collection)collectionFactory.get();
                setter.accept(target, collection);
            }
            adapter.accept(target, input, (Object)collection);
        };
    }

    public static <E, I, M extends Map<?, ?>> BeanRelationFixer<E, I> ofMapAdapter(BiConsumer<E, M> setter, Function<E, M> getter, Supplier<M> mapFactory, TriConsumer<E, I, M> adapter) {
        return (target, input) -> {
            Map map = (Map)getter.apply(target);
            if (map == null) {
                map = (Map)mapFactory.get();
                setter.accept(target, map);
            }
            adapter.accept(target, input, (Object)map);
        };
    }
}

