/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.tool.function.Serie;

public abstract class AbstractVersioningStrategy<C, V>
implements VersioningStrategy<C, V>,
Serie<V> {
    private final ReversibleAccessor<C, V> versionAccessor;
    private final Mutator<C, V> versionMutator;

    public AbstractVersioningStrategy(ReversibleAccessor<C, V> versioningAttributeAccessor) {
        this.versionAccessor = versioningAttributeAccessor;
        this.versionMutator = this.versionAccessor.toMutator();
    }

    @Override
    public ReversibleAccessor<C, V> getVersionAccessor() {
        return this.versionAccessor;
    }

    @Override
    public V getVersion(C o) {
        return (V)this.versionAccessor.get(o);
    }

    @Override
    public V upgrade(C o) {
        V currentVersion = this.getVersion(o);
        Object nextVersion = this.next(currentVersion);
        this.versionMutator.set(o, nextVersion);
        return currentVersion;
    }

    @Override
    public V revert(C o, V previousValue) {
        V currentVersion = this.getVersion(o);
        this.versionMutator.set(o, previousValue);
        return currentVersion;
    }

    public static class VersioningStrategySupport<E, V>
    extends AbstractVersioningStrategy<E, V> {
        private final Serie<V> sequence;

        public VersioningStrategySupport(ReversibleAccessor<E, V> versioningAttributeAccessor, Serie<V> sequence) {
            super(versioningAttributeAccessor);
            this.sequence = sequence;
        }

        public V next(V previousVersion) {
            return (V)this.sequence.next(previousVersion);
        }
    }
}

