/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.CommitObserver;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.RollbackObserver;
import org.codefilarete.stalactite.sql.TransactionListener;

public class TransactionListenerCollection
implements RollbackObserver,
CommitObserver,
TransactionListener {
    private Collection<TransactionListener> transactionListeners;

    public TransactionListenerCollection() {
        this(new ArrayList<TransactionListener>());
    }

    public TransactionListenerCollection(Collection<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    @Override
    public void beforeCommit() {
        this.transactionListeners.forEach(TransactionListener::beforeCommit);
        this.beforeCompletion();
    }

    @Override
    public void afterCommit() {
        this.transactionListeners.forEach(TransactionListener::afterCommit);
        this.afterCompletion();
    }

    @Override
    public void beforeRollback() {
        this.transactionListeners.forEach(TransactionListener::beforeRollback);
        this.beforeCompletion();
    }

    @Override
    public void afterRollback() {
        this.transactionListeners.forEach(TransactionListener::afterRollback);
        this.afterCompletion();
    }

    @Override
    public void beforeRollback(Savepoint savepoint) {
        this.transactionListeners.forEach(l -> l.beforeRollback(savepoint));
        this.beforeCompletion(savepoint);
    }

    @Override
    public void afterRollback(Savepoint savepoint) {
        this.transactionListeners.forEach(l -> l.afterRollback(savepoint));
        this.afterCompletion(savepoint);
    }

    @Override
    public void beforeCompletion() {
        this.transactionListeners.forEach(TransactionListener::beforeCompletion);
    }

    @Override
    public void afterCompletion() {
        this.transactionListeners.forEach(TransactionListener::afterCompletion);
        this.transactionListeners.removeIf(TransactionListener::isTemporary);
    }

    @Override
    public void addCommitListener(final CommitListener commitListener) {
        this.transactionListeners.add(new TransactionListener(){

            @Override
            public void beforeCommit() {
                commitListener.beforeCommit();
            }

            @Override
            public void afterCommit() {
                commitListener.afterCommit();
            }

            @Override
            public void beforeCompletion() {
            }

            @Override
            public void afterCompletion() {
            }

            @Override
            public boolean isTemporary() {
                return commitListener.isTemporary();
            }
        });
    }

    @Override
    public void addRollbackListener(final RollbackListener rollbackListener) {
        this.transactionListeners.add(new TransactionListener(){

            @Override
            public void beforeRollback() {
                rollbackListener.beforeRollback();
            }

            @Override
            public void afterRollback() {
                rollbackListener.afterRollback();
            }

            @Override
            public void beforeRollback(Savepoint savepoint) {
                rollbackListener.beforeRollback(savepoint);
            }

            @Override
            public void afterRollback(Savepoint savepoint) {
                rollbackListener.afterRollback(savepoint);
            }

            @Override
            public void beforeCompletion() {
            }

            @Override
            public void afterCompletion() {
            }

            @Override
            public boolean isTemporary() {
                return rollbackListener.isTemporary();
            }
        });
    }
}

