/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.oracle.statement;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.oracle.test.OracleDatabaseHelper;
import org.codefilarete.stalactite.sql.oracle.test.OracleTestDataSourceSelector;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLOperationITTest;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.function.Predicates;
import org.junit.jupiter.api.Test;

class SQLOperationOracleTest
extends SQLOperationITTest {
    private static final DataSource DATASOURCE = new OracleTestDataSourceSelector().giveDataSource();

    SQLOperationOracleTest() {
    }

    public DataSource giveDataSource() {
        return DATASOURCE;
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new OracleDatabaseHelper();
    }

    protected String giveLockStatement() {
        return "lock table Toto in exclusive mode nowait";
    }

    protected String giveCreateTableStatement() {
        return "create table Toto(id number)";
    }

    @Test
    protected void cancel() throws SQLException, InterruptedException {
        super.cancel();
    }

    protected Duo<Runnable, SQLOperation> createLockingStatement() {
        final WriteOperation testInstance = new WriteOperation((SQLStatement)new PreparedSQL("insert into Toto(id) values (42)", new HashMap()), this.connectionProvider, writeCount -> {});
        return new Duo((Object)new Runnable(){

            @Override
            public void run() {
                try {
                    testInstance.execute();
                }
                finally {
                    try {
                        SQLOperationOracleTest.this.connectionProvider.giveConnection().rollback();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }, (Object)testInstance);
    }

    protected Predicate<Throwable> giveCancelOperationPredicate() {
        return Predicates.acceptAll();
    }
}

