/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class ParameterBinderRegistryTest {
    ParameterBinderRegistryTest() {
    }

    @Test
    void getBinder_notFound() {
        ParameterBinderRegistry testInstance = new ParameterBinderRegistry();
        Assertions.assertThat((Object)testInstance.getBinder(String.class)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
    }

    @Test
    void getBinder_notRegistered_throwsException() {
        ParameterBinderRegistry testInstance = new ParameterBinderRegistry();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.getBinder(Object.class)).isInstanceOf(SQLStatement.BindingException.class)).hasMessage("No binder found for type j.l.Object");
    }

    @Test
    void getBinder_findCompliantBinder() {
        ParameterBinderRegistry testInstance = new ParameterBinderRegistry();
        Assertions.assertThat((boolean)testInstance.getBinderPerType().containsKey(StringBuilder.class)).isFalse();
        NullAwareParameterBinder expectedBinder = new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.STRING_BINDER, String::toString, CharSequence::toString));
        testInstance.register(CharSequence.class, (ParameterBinder)expectedBinder);
        Assertions.assertThat((Object)testInstance.getBinder(StringBuilder.class)).isEqualTo((Object)expectedBinder);
        Assertions.assertThat((boolean)testInstance.getBinderPerType().containsKey(StringBuilder.class)).isTrue();
    }

    @Test
    void getBinder_findCompliantBinder_enum() throws SQLException {
        ParameterBinderRegistry testInstance = new ParameterBinderRegistry();
        Assertions.assertThat((boolean)testInstance.getBinderPerType().containsKey(TimeUnit.class)).isFalse();
        ParameterBinder timeUnitBinder = testInstance.getBinder(TimeUnit.class);
        InMemoryResultSet fakeResultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, Object.class).add((Object)"X", (Object)TimeUnit.SECONDS.ordinal()), Maps.forHashMap(String.class, Object.class).add((Object)"X", null)}));
        fakeResultSet.next();
        Assertions.assertThat((Comparable)((Comparable)timeUnitBinder.get((ResultSet)fakeResultSet, "X"))).isEqualTo((Object)TimeUnit.SECONDS);
        fakeResultSet.next();
        Assertions.assertThat((Comparable)((Comparable)timeUnitBinder.get((ResultSet)fakeResultSet, "X"))).isNull();
        Assertions.assertThat((boolean)testInstance.getBinderPerType().containsKey(TimeUnit.class)).isTrue();
    }

    @Test
    void getBinder_multipleCompliantBindersFound_throwsException() {
        ParameterBinderRegistry testInstance = new ParameterBinderRegistry();
        NullAwareParameterBinder charSequenceBinder = new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.STRING_BINDER, String::toString, CharSequence::toString));
        testInstance.register(CharSequence.class, (ParameterBinder)charSequenceBinder);
        NullAwareParameterBinder serializableBinder = new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.STRING_BINDER, Object::toString, Object::toString));
        testInstance.register(Serializable.class, (ParameterBinder)serializableBinder);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.getBinder(StringBuilder.class)).isInstanceOf(SQLStatement.BindingException.class)).hasMessage("Multiple binders found for j.l.StringBuilder, please register one for any of : [j.l.CharSequence, j.i.Serializable]");
    }
}

