/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.function.SerializableThrowingFunction;
import org.codefilarete.tool.io.IOs;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ParameterBinderTest {
    ParameterBinderTest() {
    }

    @Test
    void wrap_convertASetToAString() throws SQLException {
        ParameterBinder testInstance = DefaultParameterBinders.STRING_BINDER.wrap((SerializableThrowingFunction & Serializable)setAsString -> {
            String[] databaseValue = setAsString.substring(1, setAsString.length() - 1).split(", ");
            return EnumSet.copyOf(Stream.of(databaseValue).map(ElementType::valueOf).collect(Collectors.toSet()));
        }, Object::toString);
        PreparedStatement psMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        testInstance.set(psMock, 42, EnumSet.of(ElementType.PACKAGE, ElementType.TYPE));
        ((PreparedStatement)Mockito.verify((Object)psMock)).setString(42, "[TYPE, PACKAGE]");
        ResultSet rsMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rsMock.getString((String)ArgumentMatchers.any())).thenReturn((Object)"[TYPE, PACKAGE]");
        Set actual = (Set)testInstance.get(rsMock, (String)ArgumentMatchers.any());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).containsExactlyInAnyOrder((Object[])new ElementType[]{ElementType.PACKAGE, ElementType.TYPE})).isInstanceOf(EnumSet.class);
    }

    @Test
    void wrap_convertAStringToABinaryStream() throws SQLException {
        ParameterBinder testInstance = DefaultParameterBinders.BINARYSTREAM_BINDER.wrap((SerializableThrowingFunction & Serializable)binary -> {
            try {
                byte[] byteArray = IOs.toByteArray((InputStream)binary);
                return new String(byteArray);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, (SerializableThrowingFunction & Serializable)s -> new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
        PreparedStatement psMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ArgumentCaptor psCaptor = ArgumentCaptor.forClass(InputStream.class);
        ((PreparedStatement)Mockito.doNothing().when((Object)psMock)).setBinaryStream(ArgumentMatchers.anyInt(), (InputStream)psCaptor.capture());
        testInstance.set(psMock, 42, (Object)"Hello world !");
        Assertions.assertThat((InputStream)((InputStream)psCaptor.getValue())).hasBinaryContent("Hello world !".getBytes(StandardCharsets.UTF_8));
        ResultSet rsMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rsMock.getBinaryStream((String)ArgumentMatchers.any())).thenReturn((Object)new ByteArrayInputStream("Hello world !".getBytes(StandardCharsets.UTF_8)));
        String actual = (String)testInstance.get(rsMock, (String)ArgumentMatchers.any());
        Assertions.assertThat((String)actual).isEqualTo("Hello world !");
    }

    @Test
    void wrap_convertAEnumToBoolean() throws SQLException {
        LambdaParameterBinder testInstance = new LambdaParameterBinder(DefaultParameterBinders.BOOLEAN_BINDER, (SerializableThrowingFunction & Serializable)b -> b == Boolean.TRUE ? OnOff.On : OnOff.Off, (SerializableThrowingFunction & Serializable)e -> e == OnOff.On);
        PreparedStatement psMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        testInstance.set(psMock, 42, (Object)OnOff.On);
        ((PreparedStatement)Mockito.verify((Object)psMock)).setBoolean(42, true);
        ResultSet rsMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rsMock.getBoolean((String)ArgumentMatchers.any())).thenReturn((Object)false);
        OnOff actual = (OnOff)((Object)testInstance.get(rsMock, (String)ArgumentMatchers.any()));
        Assertions.assertThat((Comparable)((Object)actual)).isEqualTo((Object)OnOff.Off);
    }

    static enum OnOff {
        On,
        Off;

    }
}

