/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Month;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.binder.OrdinalEnumParameterBinder;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class OrdinalEnumParameterBinderTest {
    OrdinalEnumParameterBinderTest() {
    }

    @Test
    void get() throws SQLException {
        OrdinalEnumParameterBinder registeredBinder = new OrdinalEnumParameterBinder(Month.class);
        InMemoryResultSet preparedStatementMock = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"month", (Object)Month.JANUARY.ordinal())}));
        preparedStatementMock.next();
        Month readMonth = (Month)registeredBinder.get((ResultSet)preparedStatementMock, "month");
        Assertions.assertThat((Comparable)((Object)readMonth)).isEqualTo((Object)Month.JANUARY);
    }

    @Test
    void set() throws SQLException {
        OrdinalEnumParameterBinder registeredBinder = new OrdinalEnumParameterBinder(Month.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        registeredBinder.set(preparedStatementMock, 1, (Object)Month.JANUARY);
        ArgumentCaptor valueCaptor = ArgumentCaptor.forClass(Integer.class);
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setInt(ArgumentMatchers.anyInt(), (Integer)valueCaptor.capture());
        Assertions.assertThat((int)((Integer)valueCaptor.getValue())).isEqualTo(Month.JANUARY.ordinal());
    }
}

