/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.TransactionObserver;
import org.codefilarete.stalactite.sql.TransactionStatusNotifier;
import org.codefilarete.stalactite.sql.TransactionStatusNotifierSupport;
import org.codefilarete.tool.sql.ConnectionWrapper;

public class TransactionAwareConnexionWrapper
extends ConnectionWrapper
implements TransactionObserver {
    private final TransactionStatusNotifier transactionStatusNotifier = new TransactionStatusNotifierSupport();

    public TransactionAwareConnexionWrapper() {
        this(null);
    }

    public TransactionAwareConnexionWrapper(Connection surrogate) {
        super(surrogate);
    }

    public TransactionStatusNotifier getTransactionStatusNotifier() {
        return this.transactionStatusNotifier;
    }

    @Override
    public void addCommitListener(CommitListener commitListener) {
        this.transactionStatusNotifier.addCommitListener(commitListener);
    }

    @Override
    public void addRollbackListener(RollbackListener rollbackListener) {
        this.transactionStatusNotifier.addRollbackListener(rollbackListener);
    }

    public void commit() throws SQLException {
        this.transactionStatusNotifier.transactionCommitTriggered();
        super.commit();
        this.transactionStatusNotifier.transactionCommitted();
    }

    public void rollback() throws SQLException {
        this.transactionStatusNotifier.transactionRollbackTriggered();
        super.rollback();
        this.transactionStatusNotifier.transactionRollbacked();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.transactionStatusNotifier.transactionRollbackTriggered(savepoint);
        super.rollback(savepoint);
        this.transactionStatusNotifier.transactionRollbacked(savepoint);
    }
}

