/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.autoconfigure;

import javax.sql.DataSource;
import org.codefilarete.stalactite.spring.autoconfigure.StalactiteProperties;
import org.codefilarete.stalactite.spring.transaction.StalactitePlatformTransactionManager;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={StalactiteProperties.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
class StalactiteConfiguration {
    private final DataSource dataSource;

    StalactiteConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionManager.class})
    public PlatformTransactionManager transactionManager(ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        StalactitePlatformTransactionManager transactionManager = new StalactitePlatformTransactionManager(this.getDataSource());
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }
}

