/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.manager;

import java.util.function.Consumer;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.runtime.WriteExecutor;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.function.Sequence;

public class BeforeInsertIdentifierManager<T, I>
implements IdentifierInsertionManager<T, I> {
    private static final InsertListener NOOP_INSERT_LISTENER = new InsertListener(){};
    private static final SelectListener NOOP_SELECT_LISTENER = new SelectListener(){};
    private final Class<I> identifierType;
    private final BeforeInsertIdentifierFixer<T, I> identifierFixer;

    public BeforeInsertIdentifierManager(IdAccessor<T, I> idAccessor, Sequence<I> sequence, Class<I> identifierType) {
        this.identifierType = identifierType;
        this.identifierFixer = new BeforeInsertIdentifierFixer<T, I>(idAccessor, sequence);
    }

    @Override
    public Class<I> getIdentifierType() {
        return this.identifierType;
    }

    public BeforeInsertIdentifierFixer<T, I> getIdentifierFixer() {
        return this.identifierFixer;
    }

    @Override
    public WriteExecutor.JDBCBatchingIterator<T> buildJDBCBatchingIterator(Iterable<? extends T> entities, WriteOperation<? extends Column<? extends Table, ?>> writeOperation, int batchSize) {
        return new JDBCBatchingIteratorIdAware<T>(entities, writeOperation, batchSize, this.identifierFixer);
    }

    @Override
    public InsertListener<T> getInsertListener() {
        return NOOP_INSERT_LISTENER;
    }

    @Override
    public SelectListener<T, I> getSelectListener() {
        return NOOP_SELECT_LISTENER;
    }

    private static class JDBCBatchingIteratorIdAware<T>
    extends WriteExecutor.JDBCBatchingIterator<T> {
        private final Consumer<T> identifierFixer;

        public JDBCBatchingIteratorIdAware(Iterable<? extends T> entities, WriteOperation writeOperation, int batchSize, Consumer<T> identifierFixer) {
            super(entities, writeOperation, batchSize);
            this.identifierFixer = identifierFixer;
        }

        public T next() {
            Object next = super.next();
            this.identifierFixer.accept(next);
            return (T)next;
        }
    }

    public static class BeforeInsertIdentifierFixer<T, I>
    implements Consumer<T> {
        private final IdAccessor<T, I> idAccessor;
        private final Sequence<I> sequence;

        public BeforeInsertIdentifierFixer(IdAccessor<T, I> idAccessor, Sequence<I> sequence) {
            this.idAccessor = idAccessor;
            this.sequence = sequence;
        }

        public Sequence<I> getSequence() {
            return this.sequence;
        }

        @Override
        public void accept(T t) {
            this.idAccessor.setId(t, this.sequence.next());
        }
    }
}

