/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.query;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EntityCriteriaSupportTest {
    EntityCriteriaSupportTest() {
    }

    @Test
    void apiUsage() {
        DefaultDialect dialect = new DefaultDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "bigint");
        RelationalEntityPersister persister = (RelationalEntityPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement()).map(Country::getName).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).build(new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), (Dialect)dialect));
        EntityCriteriaSupport countryEntityCriteriaSupport = new EntityCriteriaSupport(persister.getEntityJoinTree(), true).and(Country::getId, (ConditionalOperator)Operators.in((Object[])new Object[]{"11"})).and(Country::getName, (ConditionalOperator)Operators.eq((Object)"toto")).and(Country::getName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).and(Country::getName, (ConditionalOperator)Operators.gteq((Object)"11")).and(Country::setName, (ConditionalOperator)Operators.in((Object[])new String[]{"11"})).and(Country::setName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).and(Country::setName, (ConditionalOperator)Operators.gteq((Object)"11")).or(Country::getId, (ConditionalOperator)Operators.in((Object[])new Object[]{"11"})).or(Country::getName, (ConditionalOperator)Operators.eq((Object)"toto")).or(Country::getName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).or(Country::getName, (ConditionalOperator)Operators.gteq((Object)"11")).or(Country::setName, (ConditionalOperator)Operators.in((Object[])new String[]{"11"})).or(Country::setName, (ConditionalOperator)Operators.between((Object)"11", (Object)"")).or(Country::setName, (ConditionalOperator)Operators.gteq((Object)"11"));
        persister.selectWhere(Country::getCapital, City::getId, (ConditionalOperator)Operators.gteq((Object)"11")).and(Country::getCapital, City::getId, (ConditionalOperator)Operators.gteq((Object)"11"));
    }

    @Test
    void hasCollectionCriteria_noCollectionCriteria_returnsFalse() {
        Table personTable = new Table("Person");
        Column nameColumn = personTable.addColumn("name", String.class);
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getName), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn(Mockito.mock(IdMapping.class));
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        EntityCriteriaSupport testInstance = new EntityCriteriaSupport(new EntityJoinTree(entityMappingMock), true);
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isFalse();
        testInstance.and(Person::getName, (ConditionalOperator)Operators.eq((Object)""));
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isFalse();
    }

    @Test
    void hasCollectionCriteria_embeddedCollectionCriteria_returnsTrue() {
        Table personTable = new Table("Person");
        Column nameColumn = personTable.addColumn("name", String.class);
        EntityMapping entityMappingMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)entityMappingMock.getPropertyToColumn()).thenReturn((Object)Maps.forHashMap(ReversibleAccessor.class, Column.class).add((Object)Accessors.accessor(Person::getNicknames), (Object)nameColumn));
        Mockito.when((Object)entityMappingMock.getIdMapping()).thenReturn(Mockito.mock(IdMapping.class));
        Mockito.when((Object)entityMappingMock.getTargetTable()).thenReturn((Object)personTable);
        EntityCriteriaSupport<Person> testInstance = new EntityCriteriaSupport<Person>(new EntityJoinTree(entityMappingMock), true){

            void appendAsCriterion(LogicalOperator logicalOperator, List accessPointChain, ConditionalOperator operator) {
            }
        };
        testInstance.and(Person::getNicknames, (ConditionalOperator)Operators.eq((Object)""));
        Assertions.assertThat((boolean)testInstance.hasCollectionCriteria()).isTrue();
    }

    @Test
    void selectWhere_withCollectionCriteria() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        City grenoble = new City(new PersistableIdentifier<Long>(13L));
        grenoble.setName("Grenoble");
        country.addCity(grenoble);
        City lyon = new City(new PersistableIdentifier<Long>(17L));
        lyon.setName("Lyon");
        country.addCity(lyon);
        countryPersister.insert((Object)country);
        Country loadedCountry = (Country)countryPersister.selectWhere(Country::getCities, City::getName, (ConditionalOperator)Operators.eq((Object)"Grenoble")).execute(Accumulators.getFirstUnique());
        Assertions.assertThat((Object)loadedCountry).isNotNull();
        Assertions.assertThat((Collection)loadedCountry.getCities().stream().map(City::getName).collect(Collectors.toSet())).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
    }
}

