/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.derivation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.spring.repository.query.derivation.AbstractDerivedQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class ToCriteriaPartTreeTransformer<C>
extends AbstractDerivedQuery<C> {
    private final PartTree partTree;

    public ToCriteriaPartTreeTransformer(PartTree partTree, Class<C> entityType) {
        super(entityType);
        this.partTree = partTree;
    }

    public Condition applyTo(EntityCriteriaSupport<C> entityCriteriaSupport, EntityPersister.OrderByChain<C, ?> orderByChain, EntityPersister.LimitAware<?> limitAware) {
        Processor processor = new Processor(entityCriteriaSupport, orderByChain);
        this.partTree.forEach(x$0 -> processor.append(x$0));
        if (this.partTree.getSort().isSorted()) {
            processor.appendSort(this.partTree);
        }
        if (this.partTree.getMaxResults() != null) {
            limitAware.limit(this.partTree.getMaxResults().intValue());
        }
        return new Condition(processor.conditions);
    }

    private class Processor {
        private EntityCriteriaSupport<C> currentSupport;
        private final EntityPersister.OrderByChain<C, ?> orderByChain;
        private final List<AbstractDerivedQuery.Criterion> conditions = new ArrayList<AbstractDerivedQuery.Criterion>();

        public Processor(EntityCriteriaSupport<C> currentSupport, EntityPersister.OrderByChain<C, ?> orderByChain) {
            this.orderByChain = orderByChain;
            this.currentSupport = currentSupport;
        }

        private void appendSort(PartTree tree) {
            tree.getSort().iterator().forEachRemaining(order -> {
                AccessorChain orderProperty = ToCriteriaPartTreeTransformer.this.convertToAccessorChain((Sort.Order)order);
                this.orderByChain.orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = ToCriteriaPartTreeTransformer.this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = ToCriteriaPartTreeTransformer.this.convertToCriterion(part);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.condition);
            this.conditions.add(criterion);
        }
    }

    public static class Condition {
        private final List<AbstractDerivedQuery.Criterion> condition;

        public Condition(List<AbstractDerivedQuery.Criterion> condition) {
            this.condition = condition;
        }

        public void consume(Object[] arguments) {
            int argumentIndex = 0;
            for (AbstractDerivedQuery.Criterion criterion : this.condition) {
                criterion.setValue(arguments, argumentIndex);
                argumentIndex += criterion.argumentCount;
            }
        }
    }
}

