/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.bean.Objects;

class InMemoryRelationHolder<I, KEY_LOOKUP, ENTRY_VALUE, ENTITY> {
    private final ThreadLocal<Map<I, Set<Trio>>> relationCollectionPerEntity = new ThreadLocal();
    private final Function<Trio, Duo<Object, Object>> mapper;

    public InMemoryRelationHolder(Function<Trio, Duo<Object, Object>> mapper) {
        this.mapper = mapper;
    }

    public void storeRelation(I source, KEY_LOOKUP keyLookup, ENTRY_VALUE entryValue) {
        Map<I, Set<Trio>> srcidcMap = this.relationCollectionPerEntity.get();
        Set relatedDuos = srcidcMap.computeIfAbsent(source, id -> new HashSet());
        Trio trio = relatedDuos.stream().filter(pawn -> Objects.equals((Object)((Trio)pawn).keyLookup, (Object)keyLookup)).findAny().orElseGet(() -> {
            Trio result = new Trio();
            relatedDuos.add(result);
            return result;
        });
        trio.keyLookup = keyLookup;
        trio.entryValue = entryValue;
    }

    public void storeEntity(I source, KEY_LOOKUP keyLookup, ENTITY entity) {
        Map<I, Set<Trio>> srcidcMap = this.relationCollectionPerEntity.get();
        Set relatedDuos = srcidcMap.computeIfAbsent(source, id -> new HashSet());
        Trio trio = relatedDuos.stream().filter(pawn -> Objects.equals((Object)((Trio)pawn).keyLookup, (Object)keyLookup)).findAny().orElseGet(() -> new Trio());
        trio.entity = entity;
    }

    public Collection<Duo<Object, Object>> get(I src) {
        Map<I, Set<Trio>> currentMap = this.relationCollectionPerEntity.get();
        return (Collection)Nullable.nullable(currentMap).map(map -> (Set)map.get(src)).map(map -> map.stream().map(this.mapper::apply).collect(Collectors.toSet())).get();
    }

    public void init() {
        this.relationCollectionPerEntity.set(new HashMap());
    }

    public void clear() {
        this.relationCollectionPerEntity.remove();
    }

    public class Trio {
        private KEY_LOOKUP keyLookup;
        private ENTRY_VALUE entryValue;
        private ENTITY entity;

        public KEY_LOOKUP getKeyLookup() {
            return this.keyLookup;
        }

        public ENTRY_VALUE getEntryValue() {
            return this.entryValue;
        }

        public ENTITY getEntity() {
            return this.entity;
        }
    }
}

