/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.elementcollection;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecord;
import org.codefilarete.stalactite.engine.configurer.elementcollection.IndexedElementRecord;
import org.codefilarete.stalactite.mapping.ComposedIdMapping;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Maps;

public class IndexedElementRecordMapping<C, I, T extends Table<T>>
extends DefaultEntityMapping<IndexedElementRecord<C, I>, IndexedElementRecord<C, I>, T> {
    @VisibleForTesting
    public <LEFTTABLE extends Table<LEFTTABLE>> IndexedElementRecordMapping(T targetTable, Column<T, C> elementColumn, Column<T, Integer> indexColumn, IdentifierAssembler<I, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> foreignKeyColumnMapping) {
        super(IndexedElementRecord.class, targetTable, (Map)Maps.forHashMap(ReversibleAccessor.class, Column.class).add(ElementRecord.ELEMENT_ACCESSOR, elementColumn).add(IndexedElementRecord.INDEX_ACCESSOR, indexColumn), new IndexedElementRecordIdMapping<C, I, T>(targetTable, elementColumn, indexColumn, sourceIdentifierAssembler, foreignKeyColumnMapping));
    }

    <LEFTTABLE extends Table<LEFTTABLE>> IndexedElementRecordMapping(T targetTable, EmbeddedClassMapping<IndexedElementRecord<C, I>, T> embeddableMapping, IdentifierAssembler<I, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> foreignKeyColumnMapping) {
        super(IndexedElementRecord.class, targetTable, embeddableMapping.getPropertyToColumn(), new IndexedElementRecordIdMapping<C, I, T>(targetTable, embeddableMapping, sourceIdentifierAssembler, foreignKeyColumnMapping));
    }

    public static class IndexedElementRecordIdMapping<C, I, T extends Table<T>>
    extends ComposedIdMapping<IndexedElementRecord<C, I>, IndexedElementRecord<C, I>> {
        public <LEFTTABLE extends Table<LEFTTABLE>> IndexedElementRecordIdMapping(T targetTable, Column<T, C> elementColumn, Column<T, Integer> indexColumn, IdentifierAssembler<I, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> foreignKeyColumnMapping) {
            super(new IndexedElementRecordIdAccessor(), new AlreadyAssignedIdentifierManager(IndexedElementRecord.class, ElementRecord::markAsPersisted, ElementRecord::isPersisted), new DefaultIndexedElementRecordIdentifierAssembler((Table)targetTable, (Column)elementColumn, (Column)indexColumn, (IdentifierAssembler)sourceIdentifierAssembler, foreignKeyColumnMapping, null));
        }

        public <LEFTTABLE extends Table<LEFTTABLE>> IndexedElementRecordIdMapping(T targetTable, EmbeddedClassMapping<IndexedElementRecord<C, I>, T> elementMapping, IdentifierAssembler<I, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> foreignKeyColumnMapping) {
            super(new IndexedElementRecordIdAccessor(), new AlreadyAssignedIdentifierManager(IndexedElementRecord.class, ElementRecord::markAsPersisted, ElementRecord::isPersisted), new IndexedElementRecordIdentifierAssembler((Table)targetTable, (EmbeddedClassMapping)elementMapping, (IdentifierAssembler)sourceIdentifierAssembler, foreignKeyColumnMapping, null));
        }

        public boolean isNew(IndexedElementRecord<C, I> entity) {
            return entity.isNew();
        }

        public static class IndexedElementRecordIdentifierAssembler<TRGT, ID, T extends Table<T>>
        extends ComposedIdentifierAssembler<IndexedElementRecord<TRGT, ID>, T> {
            private final EmbeddedClassMapping<IndexedElementRecord<TRGT, ID>, T> elementMapping;
            private final IdentifierAssembler<ID, ?> sourceIdentifierAssembler;
            private final Map<Column<?, ?>, Column<T, ?>> foreignKeyColumnMapping;

            private <LEFTTABLE extends Table<LEFTTABLE>> IndexedElementRecordIdentifierAssembler(T targetTable, EmbeddedClassMapping<IndexedElementRecord<TRGT, ID>, T> elementMapping, IdentifierAssembler<ID, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> foreignKeyColumnMapping) {
                super(targetTable);
                this.elementMapping = elementMapping;
                this.sourceIdentifierAssembler = sourceIdentifierAssembler;
                this.foreignKeyColumnMapping = foreignKeyColumnMapping;
            }

            public EmbeddedClassMapping<IndexedElementRecord<TRGT, ID>, T> getElementMapping() {
                return this.elementMapping;
            }

            public IndexedElementRecord<TRGT, ID> assemble(ColumnedRow row) {
                return (IndexedElementRecord)this.elementMapping.transform(row);
            }

            public Map<Column<T, ?>, Object> getColumnValues(IndexedElementRecord<TRGT, ID> id) {
                Map sourceColumnValues = this.sourceIdentifierAssembler.getColumnValues(id.getId());
                Map idColumnValues = Maps.innerJoin(this.foreignKeyColumnMapping, (Map)sourceColumnValues);
                HashMap result = new HashMap();
                result.putAll(idColumnValues);
                result.putAll(this.elementMapping.getInsertValues(id));
                return result;
            }

            /* synthetic */ IndexedElementRecordIdentifierAssembler(Table x0, EmbeddedClassMapping x1, IdentifierAssembler x2, Map x3, 1 x4) {
                this(x0, x1, x2, x3);
            }
        }

        public static class DefaultIndexedElementRecordIdentifierAssembler<TRGT, ID, T extends Table<T>>
        extends ComposedIdentifierAssembler<IndexedElementRecord<TRGT, ID>, T> {
            private final Column<T, TRGT> elementColumn;
            private final Column<T, Integer> indexColumn;
            private final IdentifierAssembler<ID, ?> sourceIdentifierAssembler;
            private final Map<Column<?, ?>, Column<T, ?>> foreignKeyColumnMapping;

            private <LEFTTABLE extends Table<LEFTTABLE>> DefaultIndexedElementRecordIdentifierAssembler(T targetTable, Column<T, TRGT> elementColumn, Column<T, Integer> indexColumn, IdentifierAssembler<ID, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> foreignKeyColumnMapping) {
                super(targetTable);
                this.elementColumn = elementColumn;
                this.indexColumn = indexColumn;
                this.sourceIdentifierAssembler = sourceIdentifierAssembler;
                this.foreignKeyColumnMapping = foreignKeyColumnMapping;
            }

            public Column<T, TRGT> getElementColumn() {
                return this.elementColumn;
            }

            public IdentifierAssembler<ID, ?> getSourceIdentifierAssembler() {
                return this.sourceIdentifierAssembler;
            }

            public IndexedElementRecord<TRGT, ID> assemble(final ColumnedRow columnValueProvider) {
                Object leftValue = this.sourceIdentifierAssembler.assemble(new ColumnedRow(){

                    public <E> E get(Selectable<E> sourceColumn) {
                        Column targetColumn = (Column)foreignKeyColumnMapping.get(sourceColumn);
                        return (E)columnValueProvider.get((Selectable)targetColumn);
                    }
                });
                Object rightValue = columnValueProvider.get(this.elementColumn);
                if (leftValue == null || rightValue == null) {
                    return null;
                }
                return new IndexedElementRecord<Object, Object>(leftValue, rightValue, (Integer)columnValueProvider.get(this.indexColumn));
            }

            public Map<Column<T, ?>, Object> getColumnValues(IndexedElementRecord<TRGT, ID> id) {
                Map sourceColumnValues = this.sourceIdentifierAssembler.getColumnValues(id.getId());
                Map idColumnValues = Maps.innerJoin(this.foreignKeyColumnMapping, (Map)sourceColumnValues);
                HashMap result = new HashMap();
                result.put(this.indexColumn, id.getIndex());
                result.putAll(idColumnValues);
                return result;
            }

            /* synthetic */ DefaultIndexedElementRecordIdentifierAssembler(Table x0, Column x1, Column x2, IdentifierAssembler x3, Map x4, 1 x5) {
                this(x0, x1, x2, x3, x4);
            }
        }

        private static class IndexedElementRecordIdAccessor<C, I>
        implements IdAccessor<IndexedElementRecord<C, I>, IndexedElementRecord<C, I>> {
            private IndexedElementRecordIdAccessor() {
            }

            public IndexedElementRecord<C, I> getId(IndexedElementRecord<C, I> associationRecord) {
                return associationRecord;
            }

            public void setId(IndexedElementRecord<C, I> associationRecord, IndexedElementRecord<C, I> identifier) {
                associationRecord.setId(identifier.getId());
                associationRecord.setIndex(identifier.getIndex());
                associationRecord.setElement(identifier.getElement());
            }
        }
    }
}

