/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingConfigurationSupportTest;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.configurer.ToStringBuilder;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.model.Truck;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.Length;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class FluentEntityMappingConfigurationSupportCollectionOfElementsTest {
    private static final Class<Identifier<UUID>> UUID_TYPE = Identifier.class;
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportCollectionOfElementsTest() {
    }

    @BeforeEach
    void initTest() {
        this.dialect.getDmlGenerator().sortColumnsAlphabetically();
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void insert() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).containsExactlyInAnyOrder((Object[])new String[]{"tonton"});
    }

    @Test
    void update_withNewObject() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        person.addNickname("tintin");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).containsExactlyInAnyOrder((Object[])new String[]{"tintin", "tonton"});
        loadedPerson.addNickname("toutou");
        personPersister.update((Object)loadedPerson, (Object)person, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).containsExactlyInAnyOrder((Object[])new String[]{"tintin", "tonton", "toutou"});
    }

    @Test
    void update_objectRemoval() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        person.addNickname("tintin");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        person.getNicknames().remove("tintin");
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).containsExactlyInAnyOrder((Object[])new String[]{"tonton"});
    }

    @Test
    void delete() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        person.addNickname("tintin");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        personPersister.delete((Object)loadedPerson);
        Set remainingNickNames = (Set)this.persistenceContext.newQuery((CharSequence)"select nickNames from Person_nicknames", String.class).mapKey("nickNames", String.class).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingNickNames).isEmpty();
    }

    @Test
    void withCollectionFactory() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).initializeWith(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER.reversed())).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("d");
        person.addNickname("a");
        person.addNickname("c");
        person.addNickname("b");
        Assertions.assertThat(person.getNicknames()).containsExactly((Object[])new String[]{"a", "b", "c", "d"});
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).containsExactly((Object[])new String[]{"d", "c", "b", "a"});
    }

    @Test
    void foreignKeyIsPresent() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Person_nicknames_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void mappedBy() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).reverseJoinColumn("identifier").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Person_nicknames_identifier_Person_id", nickNamesTable.getColumn("identifier"), personTable.getColumn("id"))});
    }

    @Test
    void withElementCollectionTableNaming() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).withElementCollectionTableNaming(accessorDefinition -> "Toto").mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Toto");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withTable() {
        Table nickNamesTable = new Table("Toto");
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).onTable(nickNamesTable).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter)).containsExactly(new Object[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withTableName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).onTable("Toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Toto");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void changeColumnName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).elementColumnName("toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Assertions.assertThat(nickNamesTable.mapColumnsOnName().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"id", "toto"});
    }

    @Test
    void changeColumnSize() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).elementColumnSize((Size)Size.length((int)36)).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Assertions.assertThat((Object)((Column)nickNamesTable.mapColumnsOnName().get("nicknames")).getSize()).usingRecursiveComparison().isEqualTo((Object)Size.length((int)36));
    }

    @Test
    void read_deepInTree() {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(p -> p.getId().setPersisted(), p -> p.getId().isPersisted())).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(p -> p.getId().setPersisted(), p -> p.getId().isPersisted())).map(Person::getName).mapCollection(Person::getNicknames, String.class)).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(p -> p.getId().setPersisted(), p -> p.getId().isPersisted())).map(City::getName)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(42L);
        country.setName("Toto");
        country.addCity(new City(111L));
        country.addCity(new City(222L));
        Person president = new Person(666L);
        president.setName("me");
        president.initNicknames();
        president.addNickname("John Do");
        president.addNickname("Jane Do");
        country.setPresident(president);
        countryPersister.insert(Arrays.asList(country));
        Country loadedCountry = (Country)countryPersister.select(country.getId());
        Assertions.assertThat(loadedCountry.getPresident().getNicknames()).containsExactlyInAnyOrderElementsOf(country.getPresident().getNicknames());
    }

    @Nested
    class OnSubEntity {
        OnSubEntity() {
        }

        @Test
        void crudComplexType_overrideColumnName() {
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getSqlTypeRegistry().put(Color.class, "int");
            MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).mapCollection(Car::getPlates, String.class).elementColumnName("toto").mapCollection(Car::getInspections, Timestamp.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("createdAt").map(Timestamp::getModificationDate).columnName("modifiedAt")).overrideName(Timestamp::getCreationDate, "inspectionDate").overrideSize(Timestamp::getCreationDate, (Size)Size.length((int)36)).reverseJoinColumn("car_id").onTable("inspections"), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor), (Object)"TRUCK")).build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
            Table platesTable = (Table)tablePerName.get("Car_plates");
            Assertions.assertThat(platesTable.mapColumnsOnName().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"id", "toto"});
            Table inspectionsTable = (Table)tablePerName.get("inspections");
            Assertions.assertThat(inspectionsTable.mapColumnsOnName().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"car_id", "modifiedAt", "inspectionDate"});
            Assertions.assertThat((Object)((Column)inspectionsTable.mapColumnsOnName().get("inspectionDate")).getSize()).usingRecursiveComparison().isEqualTo((Object)Size.length((int)36));
        }
    }

    @Nested
    class Complex_CRUD {
        Complex_CRUD() {
        }

        @Test
        void crudEnum() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).mapCollection(FluentEntityMappingConfigurationSupportTest.Toto::getPossibleStates, FluentEntityMappingConfigurationSupportTest.State.class).build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportTest.Toto person = new FluentEntityMappingConfigurationSupportTest.Toto();
            person.setName("toto");
            person.getPossibleStates().add(FluentEntityMappingConfigurationSupportTest.State.DONE);
            person.getPossibleStates().add(FluentEntityMappingConfigurationSupportTest.State.IN_PROGRESS);
            personPersister.insert((Object)person);
            FluentEntityMappingConfigurationSupportTest.Toto loadedPerson = (FluentEntityMappingConfigurationSupportTest.Toto)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getPossibleStates()).containsExactlyInAnyOrder((Object[])new FluentEntityMappingConfigurationSupportTest.State[]{FluentEntityMappingConfigurationSupportTest.State.DONE, FluentEntityMappingConfigurationSupportTest.State.IN_PROGRESS});
        }

        @Test
        void crudComplexType() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).mapCollection(FluentEntityMappingConfigurationSupportTest.Toto::getTimes, Timestamp.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportTest.Toto person = new FluentEntityMappingConfigurationSupportTest.Toto();
            person.setName("toto");
            Timestamp timestamp1 = new Timestamp(LocalDateTime.now().plusDays(1L), LocalDateTime.now().plusDays(1L));
            Timestamp timestamp2 = new Timestamp(LocalDateTime.now().plusDays(2L), LocalDateTime.now().plusDays(2L));
            person.getTimes().add(timestamp1);
            person.getTimes().add(timestamp2);
            personPersister.insert((Object)person);
            FluentEntityMappingConfigurationSupportTest.Toto loadedPerson = (FluentEntityMappingConfigurationSupportTest.Toto)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getTimes()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new Timestamp[]{timestamp1, timestamp2}));
        }

        @Test
        void crudComplexType_overrideColumnName() {
            Table totoTable = new Table("toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).mapCollection(FluentEntityMappingConfigurationSupportTest.Toto::getTimes, Timestamp.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).overrideName(Timestamp::getCreationDate, "createdAt").overrideSize(Timestamp::getCreationDate, (Size)Size.length((int)36)).build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
            Table totoTimesTable = (Table)tablePerName.get("Toto_times");
            Map timesTableColumn = totoTimesTable.mapColumnsOnName();
            Assertions.assertThat(timesTableColumn.get("createdAt")).isNotNull();
            Assertions.assertThat((Object)((Column)timesTableColumn.get("createdAt")).getSize()).extracting(Length.class::cast).extracting(Length::getValue).isEqualTo((Object)36);
            FluentEntityMappingConfigurationSupportTest.Toto person = new FluentEntityMappingConfigurationSupportTest.Toto();
            person.setName("toto");
            Timestamp timestamp1 = new Timestamp(LocalDateTime.now().plusDays(1L), LocalDateTime.now().plusDays(1L));
            Timestamp timestamp2 = new Timestamp(LocalDateTime.now().plusDays(2L), LocalDateTime.now().plusDays(2L));
            person.getTimes().add(timestamp1);
            person.getTimes().add(timestamp2);
            personPersister.insert((Object)person);
            FluentEntityMappingConfigurationSupportTest.Toto loadedPerson = (FluentEntityMappingConfigurationSupportTest.Toto)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getTimes()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new Timestamp[]{timestamp1, timestamp2}));
        }
    }

    @Nested
    class KeepOrder {
        KeepOrder() {
        }

        @Test
        void insert() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getMiddleNames, String.class).indexed().build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setMiddleNames(org.codefilarete.tool.collection.Arrays.asList((Object[])new String[]{"Toto", "Tata", "Titi"}));
            Collections.shuffle(person.getMiddleNames());
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMiddleNames()).containsExactlyElementsOf(person.getMiddleNames());
        }

        @Test
        void update() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getMiddleNames, String.class).indexed().build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setMiddleNames(org.codefilarete.tool.collection.Arrays.asList((Object[])new String[]{"Toto", "Tata", "Titi"}));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            loadedPerson.getMiddleNames().add(1, "Tutu");
            loadedPerson.getMiddleNames().remove("Tata");
            personPersister.update((Object)loadedPerson, (Object)person, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMiddleNames()).containsExactlyInAnyOrder((Object[])new String[]{"Toto", "Tutu", "Titi"});
        }

        @Test
        void delete() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getMiddleNames, String.class).indexed().build(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setMiddleNames(org.codefilarete.tool.collection.Arrays.asList((Object[])new String[]{"Toto", "Tata", "Titi"}));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            Set remainingMiddleNames = (Set)FluentEntityMappingConfigurationSupportCollectionOfElementsTest.this.persistenceContext.newQuery((CharSequence)"select middleNames from Person_middleNames", String.class).mapKey("middleNames", String.class).execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingMiddleNames).isEmpty();
        }
    }
}

