/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.cascade.AfterInsertCollectionCascader;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationRecord;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.tool.trace.MutableInt;

public class IndexedAssociationRecordInsertionCascader<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>>
extends AfterInsertCollectionCascader<SRC, IndexedAssociationRecord> {
    private final Function<SRC, C> collectionGetter;
    private final EntityMapping<SRC, SRCID, ?> mappingStrategy;
    private final EntityMapping<TRGT, TRGTID, ?> targetStrategy;

    public IndexedAssociationRecordInsertionCascader(AssociationRecordPersister<IndexedAssociationRecord, ?> persister, Function<SRC, C> collectionGetter, EntityMapping<SRC, SRCID, ?> mappingStrategy, EntityMapping<TRGT, TRGTID, ?> targetStrategy) {
        super(persister);
        this.collectionGetter = collectionGetter;
        this.mappingStrategy = mappingStrategy;
        this.targetStrategy = targetStrategy;
    }

    @Override
    protected void postTargetInsert(Iterable<? extends IndexedAssociationRecord> entities) {
    }

    @Override
    protected Collection<IndexedAssociationRecord> getTargets(SRC src) {
        Collection targets = (Collection)this.collectionGetter.apply(src);
        ArrayList<IndexedAssociationRecord> result = new ArrayList<IndexedAssociationRecord>(targets.size());
        MutableInt index = new MutableInt(0);
        targets.forEach(target -> result.add(new IndexedAssociationRecord(this.mappingStrategy.getId(src), this.targetStrategy.getId(target), index.increment())));
        return result;
    }
}

