/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codefilarete.stalactite.engine.model.AbstractCountry;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Language;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.State;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.model.Town;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;

public class Country
extends AbstractCountry
implements Identified<Long> {
    private Identifier<Long> id;
    private String name;
    private String description;
    private Person president;
    private City capital;
    private Set<City> cities;
    private List<City> ancientCities = new ArrayList<City>();
    private Set<Town> towns;
    private Set<State> states = new HashSet<State>();
    private int version;
    private int versionWithoutAccessor;
    private LocalDateTime modificationDate;
    private Timestamp timestamp;
    private Set<Language> languages = new HashSet<Language>();
    private boolean hasNuclearPower;
    private boolean euMember;

    public Country() {
    }

    public Country(long id) {
        this(new PersistableIdentifier<Long>(id));
    }

    public Country(Identifier<Long> id) {
        this.id = id;
    }

    @Override
    public Identifier<Long> getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        Country country = (Country)o;
        return ((Long)this.id.getDelegate()).equals(country.id.getDelegate());
    }

    public int hashCode() {
        return ((Long)this.id.getDelegate()).hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Person getPresident() {
        return this.president;
    }

    public void setPresident(Person president) {
        this.president = president;
    }

    public City getCapital() {
        return this.capital;
    }

    public void setCapital(City capital) {
        if (this.capital != null) {
            this.capital.setCountry(null);
        }
        this.capital = capital;
        if (this.capital != null) {
            this.capital.setCountry(this);
        }
    }

    public Set<City> getCities() {
        return this.cities;
    }

    public void setCities(Set<City> cities) {
        this.cities = cities;
    }

    public void addCity(City city) {
        if (this.cities == null) {
            this.cities = new LinkedHashSet<City>();
        }
        this.cities.add(city);
        city.setCountry(this);
    }

    public List<City> getAncientCities() {
        return this.ancientCities;
    }

    public void setAncientCities(List<City> ancientCities) {
        this.ancientCities = ancientCities;
    }

    public void addAncientCity(City city) {
        this.ancientCities.add(city);
        city.setCountry(this);
    }

    public Set<Town> getTowns() {
        return this.towns;
    }

    public void addTown(Town town) {
        if (this.towns == null) {
            this.towns = new LinkedHashSet<Town>();
        }
        this.towns.add(town);
        town.setCountry(this);
    }

    public Set<State> getStates() {
        return this.states;
    }

    public void setStates(Set<State> states) {
        this.states = states;
    }

    public void addState(State state) {
        this.states.add(state);
        state.setCountry(this);
    }

    public int getVersion() {
        return this.version;
    }

    public LocalDateTime getModificationDate() {
        return this.modificationDate;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public Set<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Set<Language> languages) {
        this.languages = languages;
    }

    public boolean hasNuclearPower() {
        return this.hasNuclearPower;
    }

    public void nuclearPower(boolean hasNuclearPower) {
        this.hasNuclearPower = hasNuclearPower;
    }

    public boolean isEuMember() {
        return this.euMember;
    }

    public void setEuMember(boolean euMember) {
        this.euMember = euMember;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

