/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.elementcollection;

import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.configurer.LambdaMethodUnsheller;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ElementCollectionRelation<SRC, TRGT, S extends Collection<TRGT>> {
    private final ReversibleAccessor<SRC, S> collectionAccessor;
    private final Class<TRGT> componentType;
    private Supplier<S> collectionFactory;
    private Table targetTable;
    private String targetTableName;
    private Column<Table, ?> reverseColumn;
    private String reverseColumnName;
    private String elementColumnName;
    @Nullable
    private final EmbeddableMappingConfigurationProvider<TRGT> embeddableConfigurationProvider;
    private final ValueAccessPointMap<SRC, String> overriddenColumnNames = new ValueAccessPointMap();
    private final ValueAccessPointMap<SRC, Size> overriddenColumnSizes = new ValueAccessPointMap();
    private Size elementColumnSize;

    public ElementCollectionRelation(SerializableBiConsumer<SRC, S> setter, Class<TRGT> componentType, @Nullable EmbeddableMappingConfigurationProvider<TRGT> embeddableConfigurationProvider) {
        MutatorByMethodReference setterReference = Accessors.mutatorByMethodReference(setter);
        this.collectionAccessor = new PropertyAccessor((Accessor)Accessors.accessor((Class)setterReference.getDeclaringClass(), (String)Reflections.propertyName((String)setterReference.getMethodName())), (Mutator)setterReference);
        this.componentType = componentType;
        this.embeddableConfigurationProvider = embeddableConfigurationProvider;
    }

    public ElementCollectionRelation(SerializableFunction<SRC, S> getter, Class<TRGT> componentType, LambdaMethodUnsheller lambdaMethodUnsheller, @Nullable EmbeddableMappingConfigurationProvider<TRGT> embeddableConfigurationProvider) {
        AccessorByMethodReference getterReference = Accessors.accessorByMethodReference(getter);
        this.collectionAccessor = new PropertyAccessor((Accessor)getterReference, new AccessorByMethod(lambdaMethodUnsheller.captureLambdaMethod(getter)).toMutator());
        this.componentType = componentType;
        this.embeddableConfigurationProvider = embeddableConfigurationProvider;
    }

    public ElementCollectionRelation(ReversibleAccessor<SRC, S> collectionAccessor, Class<TRGT> componentType, @Nullable EmbeddableMappingConfigurationProvider<TRGT> embeddableConfigurationProvider) {
        this.collectionAccessor = collectionAccessor;
        this.componentType = componentType;
        this.embeddableConfigurationProvider = embeddableConfigurationProvider;
    }

    public ReversibleAccessor<SRC, S> getCollectionAccessor() {
        return this.collectionAccessor;
    }

    public Supplier<S> getCollectionFactory() {
        return this.collectionFactory;
    }

    public ElementCollectionRelation<SRC, TRGT, S> setCollectionFactory(Supplier<? extends S> collectionFactory) {
        this.collectionFactory = collectionFactory;
        return this;
    }

    public ValueAccessPointMap<SRC, String> getOverriddenColumnNames() {
        return this.overriddenColumnNames;
    }

    public void overrideName(SerializableFunction methodRef, String columnName) {
        this.overriddenColumnNames.put((Object)new AccessorByMethodReference(methodRef), (Object)columnName);
    }

    public void overrideName(SerializableBiConsumer methodRef, String columnName) {
        this.overriddenColumnNames.put((Object)new MutatorByMethodReference(methodRef), (Object)columnName);
    }

    public void overrideSize(SerializableFunction methodRef, Size columnSize) {
        this.overriddenColumnSizes.put((Object)new AccessorByMethodReference(methodRef), (Object)columnSize);
    }

    public void overrideSize(SerializableBiConsumer methodRef, Size columnSize) {
        this.overriddenColumnSizes.put((Object)new MutatorByMethodReference(methodRef), (Object)columnSize);
    }

    public ValueAccessPointMap<SRC, Size> getOverriddenColumnSizes() {
        return this.overriddenColumnSizes;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public ElementCollectionRelation<SRC, TRGT, S> setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
        return this;
    }

    public <I> Column<Table, I> getReverseColumn() {
        return this.reverseColumn;
    }

    public void setReverseColumn(Column<Table, ?> reverseColumn) {
        this.reverseColumn = reverseColumn;
    }

    public String getReverseColumnName() {
        return this.reverseColumnName;
    }

    public ElementCollectionRelation<SRC, TRGT, S> setReverseColumnName(String reverseColumnName) {
        this.reverseColumnName = reverseColumnName;
        return this;
    }

    public Class<TRGT> getComponentType() {
        return this.componentType;
    }

    public EmbeddableMappingConfigurationProvider<TRGT> getEmbeddableConfigurationProvider() {
        return this.embeddableConfigurationProvider;
    }

    public void setElementColumnName(String columnName) {
        this.elementColumnName = columnName;
    }

    public String getElementColumnName() {
        return this.elementColumnName;
    }

    public void setElementColumnSize(Size elementColumnSize) {
        this.elementColumnSize = elementColumnSize;
    }

    public Size getElementColumnSize() {
        return this.elementColumnSize;
    }

    public <C> ElementCollectionRelation<C, TRGT, S> embedInto(final Accessor<C, SRC> accessor, final Class<SRC> embeddedType) {
        AccessorChain shiftedTargetProvider = new AccessorChain(new Accessor[]{accessor, this.collectionAccessor});
        shiftedTargetProvider.setNullValueHandler((AccessorChain.NullValueHandler)new AccessorChain.ValueInitializerOnNullValue(){

            protected <T> T newInstance(Accessor<?, T> segmentAccessor, Class<T> valueType) {
                if (segmentAccessor == accessor) {
                    return (T)Reflections.newInstance((Class)embeddedType);
                }
                if (segmentAccessor == ElementCollectionRelation.this.collectionAccessor) {
                    if (ElementCollectionRelation.this.collectionFactory != null) {
                        return ElementCollectionRelation.this.collectionFactory.get();
                    }
                    return (T)super.newInstance(segmentAccessor, valueType);
                }
                return (T)super.newInstance(segmentAccessor, valueType);
            }
        });
        ElementCollectionRelation<SRC, TRGT, S> result = new ElementCollectionRelation<SRC, TRGT, S>(shiftedTargetProvider, this.componentType, this.embeddableConfigurationProvider);
        result.setElementColumnName(this.getElementColumnName());
        result.setElementColumnSize(this.getElementColumnSize());
        result.setTargetTable(this.getTargetTable());
        result.setTargetTableName(this.getTargetTableName());
        result.setReverseColumn(this.getReverseColumn());
        result.setReverseColumnName(this.getReverseColumnName());
        result.getOverriddenColumnNames().putAll(this.getOverriddenColumnNames());
        result.getOverriddenColumnSizes().putAll(this.getOverriddenColumnSizes());
        result.setCollectionFactory(this.getCollectionFactory());
        return result;
    }
}

