/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.ThrowingBiFunction;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractDMLExecutorMockTest
extends DMLExecutorTest {
    protected JdbcMock jdbcMock;
    protected WriteOperationFactory noRowCountCheckWriteOperationFactory;

    @BeforeEach
    void init() {
        this.jdbcMock = new JdbcMock();
        this.noRowCountCheckWriteOperationFactory = new WriteOperationFactory(){

            protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
                return new WriteOperation<ParamType>(sqlGenerator, connectionProvider, NOOP_COUNT_CHECKER){

                    protected void prepareStatement(Connection connection) throws SQLException {
                        this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                    }
                };
            }
        };
    }

    public static void assertCapturedPairsEqual(JdbcMock jdbcMock, PairSetList<Integer, Integer> expectedPairs) {
        List obtainedPairs = PairSetList.toPairs(jdbcMock.indexCaptor.getAllValues(), jdbcMock.valueCaptor.getAllValues());
        ArrayList obtained = new ArrayList();
        int startIndex = 0;
        for (Set<Duo<Integer, Integer>> expectedPair : expectedPairs.asList()) {
            obtained.add(new HashSet(obtainedPairs.subList(startIndex, startIndex += expectedPair.size())));
        }
        Assertions.assertThat(obtained).isEqualTo(expectedPairs.asList());
    }

    protected static class JdbcMock {
        protected PreparedStatement preparedStatement;
        protected ArgumentCaptor<Integer> valueCaptor;
        protected ArgumentCaptor<Integer> indexCaptor;
        protected ArgumentCaptor<String> sqlCaptor;
        protected ConnectionProvider transactionManager;
        protected Connection connection;

        protected JdbcMock() {
            try {
                this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
                Mockito.when((Object)this.preparedStatement.executeLargeBatch()).thenReturn((Object)new long[]{1L});
                this.connection = (Connection)Mockito.mock(Connection.class);
                Mockito.when((Object)this.preparedStatement.getConnection()).thenReturn((Object)this.connection);
                this.sqlCaptor = ArgumentCaptor.forClass(String.class);
                Mockito.when((Object)this.connection.prepareStatement((String)this.sqlCaptor.capture())).thenReturn((Object)this.preparedStatement);
                Mockito.when((Object)this.connection.prepareStatement((String)this.sqlCaptor.capture(), ArgumentMatchers.anyInt())).thenReturn((Object)this.preparedStatement);
                this.valueCaptor = ArgumentCaptor.forClass(Integer.class);
                this.indexCaptor = ArgumentCaptor.forClass(Integer.class);
                DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
                Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)this.connection);
                this.transactionManager = new CurrentThreadConnectionProvider(dataSource);
            }
            catch (SQLException e) {
                throw Exceptions.asRuntimeException((Throwable)e);
            }
        }
    }
}

