/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.util.Collections;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.engine.SQLOperationsFactoriesBuilder;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelector;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.PostgreSQLDialectResolver;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.PostgreSQLParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.PostgreSQLTypeMapping;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.CaseInsensitiveSet;
import org.codefilarete.tool.collection.Sorter;

public class PostgreSQLDatabaseSettings
extends DatabaseVendorSettings {
    public static final String[] KEYWORDS = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ASC", "ASYMMETRIC", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "FALSE", "FOREIGN", "IN", "INITIALLY", "LATERAL", "LEADING", "LOCALTIME", "LOCALTIMESTAMP", "NOT", "NULL", "ONLY", "OR", "PLACING", "PRIMARY", "REFERENCES", "SELECT", "SESSION_USER", "SOME", "SYMMETRIC", "SYSTEM_USER", "TABLE", "THEN", "TRAILING", "TRUE", "UNIQUE", "USER", "USING", "VARIADIC", "WHEN"};
    public static final PostgreSQLDatabaseSettings POSTGRESQL_9_6 = new PostgreSQLDatabaseSettings();

    private PostgreSQLDatabaseSettings() {
        this(new PostgreSQLSQLOperationsFactoriesBuilder(), new PostgreSQLParameterBinderRegistry());
    }

    private PostgreSQLDatabaseSettings(PostgreSQLSQLOperationsFactoriesBuilder sqlOperationsFactoriesBuilder, PostgreSQLParameterBinderRegistry parameterBinderRegistry) {
        super((ServiceLoaderDialectResolver.DatabaseSignet)new PostgreSQLDialectResolver.PostgreSQLDatabaseSignet(9, 6), Collections.unmodifiableSet(new CaseInsensitiveSet(KEYWORDS)), '`', (JavaTypeToSqlTypeMapping)new PostgreSQLTypeMapping(), (ParameterBinderRegistry)parameterBinderRegistry, (SQLOperationsFactoriesBuilder)sqlOperationsFactoriesBuilder, (GeneratedKeysReaderFactory)new GeneratedKeysReaderFactory.DefaultGeneratedKeysReaderFactory((ParameterBinderRegistry)parameterBinderRegistry), 1000, true);
    }

    @VisibleForTesting
    static class PostgreSQLSequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        private final ReadOperationFactory readOperationFactory;

        private PostgreSQLSequenceSelectorFactory(ReadOperationFactory readOperationFactory) {
            this.readOperationFactory = readOperationFactory;
        }

        public DatabaseSequenceSelector create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new DatabaseSequenceSelector(databaseSequence, "select nextval('" + databaseSequence.getAbsoluteName() + "')", this.readOperationFactory, connectionProvider);
        }
    }

    public static class PostgreSQLDDLTableGenerator
    extends DDLTableGenerator {
        public PostgreSQLDDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProviderFactory dmlNameProviderFactory) {
            super(typeMapping, dmlNameProviderFactory);
        }

        protected String getSqlType(Column column) {
            String sqlType = column.isAutoGenerated() ? "BIGSERIAL" : super.getSqlType(column);
            return sqlType;
        }
    }

    private static class PostgreSQLSQLOperationsFactoriesBuilder
    implements SQLOperationsFactoriesBuilder {
        private final ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        private final WriteOperationFactory writeOperationFactory = new WriteOperationFactory();

        private PostgreSQLSQLOperationsFactoriesBuilder() {
        }

        private ReadOperationFactory getReadOperationFactory() {
            return this.readOperationFactory;
        }

        private WriteOperationFactory getWriteOperationFactory() {
            return this.writeOperationFactory;
        }

        public SQLOperationsFactories build(ParameterBinderIndex<Column, ParameterBinder> parameterBinders, DMLNameProviderFactory dmlNameProviderFactory, SqlTypeRegistry sqlTypeRegistry) {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            PostgreSQLDDLTableGenerator ddlTableGenerator = new PostgreSQLDDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories(this.writeOperationFactory, this.readOperationFactory, dmlGenerator, (DDLTableGenerator)ddlTableGenerator, ddlSequenceGenerator, (DatabaseSequenceSelectorFactory)new PostgreSQLSequenceSelectorFactory(this.readOperationFactory));
        }
    }
}

