/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.tableperclass;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityMappingWrapper;
import org.codefilarete.stalactite.engine.runtime.FirstPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.RelationIds;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SecondPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.PolymorphicMergeJoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassPolymorphicRelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.tableperclass.TablePerClassPolymorphismEntityFinder;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.trace.MutableInt;

public class TablePerClassPolymorphismPersister<C, I, T extends Table<T>>
extends AbstractPolymorphismPersister<C, I> {
    private static final ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> DIFFERED_ENTITY_LOADER = new ThreadLocal();

    public TablePerClassPolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister, subEntitiesPersisters, new TablePerClassPolymorphismEntityFinder(mainPersister, subEntitiesPersisters, connectionProvider, dialect));
        this.subEntitiesPersisters.forEach((type, persister) -> mainPersister.getEntityJoinTree().projectTo(persister.getEntityJoinTree(), "ROOT"));
    }

    @Override
    public <LEFTTABLE extends Table<LEFTTABLE>, SUBTABLE extends Table<SUBTABLE>, JOINTYPE> void propagateMappedAssociationToSubTables(Key<SUBTABLE, JOINTYPE> foreignKey, PrimaryKey<LEFTTABLE, JOINTYPE> leftPrimaryKey, BiFunction<Key<SUBTABLE, JOINTYPE>, PrimaryKey<LEFTTABLE, JOINTYPE>, String> foreignKeyNamingFunction) {
        this.subEntitiesPersisters.values().stream().forEach(subPersister -> {
            Object subTable = subPersister.getMainTable();
            Key.KeyBuilder projectedKeyBuilder = Key.from(subTable);
            foreignKey.getColumns().forEach(column -> {
                Column subtableColumn = subTable.addColumn(column.getName(), column.getJavaType(), column.getSize(), column.isNullable());
                projectedKeyBuilder.addColumn((JoinLink)subtableColumn);
                subPersister.getEntityJoinTree().getRoot().getOriginalColumnsToLocalOnes().put((JoinLink<?, ?>)subtableColumn, (JoinLink<?, ?>)subtableColumn);
            });
            Key projectedKey = projectedKeyBuilder.build();
            subPersister.getEntityJoinTree().addPassiveJoin("ROOT", foreignKey, projectedKey, EntityJoinTree.JoinType.INNER, Collections.emptySet());
            subTable.addForeignKey(foreignKeyNamingFunction, projectedKey, (Key)leftPrimaryKey);
        });
    }

    @Override
    public Set<Class<? extends C>> getSupportedEntityTypes() {
        HashSet result = new HashSet();
        this.subEntitiesPersisters.forEach((c, p) -> {
            if (p instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)p)).getSupportedEntityTypes());
            } else if (p instanceof PersisterWrapper && ((PersisterWrapper)p).getDeepestDelegate() instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)((PersisterWrapper)p).getDeepestDelegate())).getSupportedEntityTypes());
            } else {
                result.add((Class)c);
            }
        });
        return result;
    }

    public Collection<Table<?>> giveImpliedTables() {
        return this.subEntitiesPersisters.values().stream().flatMap(p -> p.giveImpliedTables().stream()).collect(Collectors.toList());
    }

    public void doInsert(Iterable<? extends C> entities) {
        Map entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(InsertExecutor::insert);
    }

    public void doUpdateById(Iterable<? extends C> entities) {
        Map entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(UpdateExecutor::updateById);
    }

    public void doUpdate(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        differencesIterable.forEach(arg_0 -> this.lambda$doUpdate$7((Map)entitiesPerType, arg_0));
        entitiesPerType.forEach((updateExecutor, adhocEntities) -> updateExecutor.update((Iterable)adhocEntities, allColumnsStatement));
    }

    public void doDelete(Iterable<? extends C> entities) {
        Map entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::delete);
    }

    public void doDeleteById(Iterable<? extends C> entities) {
        Map entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::deleteById);
    }

    private <D extends C> Map<EntityPersister<D, I>, Set<D>> computeEntitiesPerPersister(Iterable<? extends C> entities) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        entities.forEach(arg_0 -> this.lambda$computeEntitiesPerPersister$11((Map)entitiesPerType, arg_0));
        return entitiesPerType;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
        this.getEntityJoinTree().projectTo(this.getEntityJoinTree(), joinName);
    }

    public EntityMapping<C, I, T> getMapping() {
        return new EntityMappingWrapper<C, I, T>(this.mainPersister.getMapping()){

            @Override
            public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
                Collection subPersisters = TablePerClassPolymorphismPersister.this.subEntitiesPersisters.values();
                subPersisters.forEach(persister -> persister.getMapping().addTransformerListener(listener));
            }

            @Override
            public void addShadowColumnInsert(Mapping.ShadowColumnValueProvider<C, T> provider) {
                TablePerClassPolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addShadowColumnInsert(this.projectShadowColumnProvider(provider, (ConfiguredRelationalPersister)p)));
            }

            @Override
            public void addShadowColumnUpdate(Mapping.ShadowColumnValueProvider<C, T> provider) {
                TablePerClassPolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addShadowColumnUpdate(this.projectShadowColumnProvider(provider, (ConfiguredRelationalPersister)p)));
            }

            private <D extends C, SUBENTITYTABLE extends Table<SUBENTITYTABLE>> Mapping.ShadowColumnValueProvider<D, SUBENTITYTABLE> projectShadowColumnProvider(final Mapping.ShadowColumnValueProvider<C, T> provider, ConfiguredRelationalPersister<D, I> subEntityPersister) {
                final HashMap projectedColumnMap = new HashMap(provider.getColumns().size());
                provider.getColumns().forEach(c -> {
                    Column projectedColumn = subEntityPersister.getMapping().getTargetTable().addColumn(c.getName(), c.getJavaType(), c.getSize(), c.isNullable());
                    projectedColumnMap.put(c, projectedColumn);
                });
                return new Mapping.ShadowColumnValueProvider<D, SUBENTITYTABLE>(){
                    private final Set<Column<SUBENTITYTABLE, ?>> values;
                    {
                        this.values = new HashSet(projectedColumnMap.values());
                    }

                    public Set<Column<SUBENTITYTABLE, ?>> getColumns() {
                        return this.values;
                    }

                    public Map<Column<SUBENTITYTABLE, ?>, ?> giveValue(D bean) {
                        Map columnObjectMap = provider.giveValue(bean);
                        return Maps.innerJoin((Map)projectedColumnMap, (Map)columnObjectMap);
                    }
                };
            }
        };
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, C> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            String createdJoinNodeName = this.joinAsOneWithSeparateLoading(sourcePersister.getEntityJoinTree(), "ROOT", leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()));
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, DIFFERED_ENTITY_LOADER));
            return createdJoinNodeName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), "ROOT", propertyAccessor, leftColumn, rightColumn, beanRelationFixer);
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(String joinName, RelationalEntityPersister<SRC, SRCID> sourcePersister, Accessor<SRC, ?> propertyAccessor, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @Nullable Function<ColumnedRow, Object> duplicateIdentifierProvider, Set<? extends Column<T2, ?>> selectableColumns, boolean optional, boolean loadSeparately) {
        PrimaryKey mainTablePK = this.mainPersister.getMapping().getTargetTable().getPrimaryKey();
        HashMap joinColumnPerSubPersister = new HashMap();
        if (rightColumn.equals((Object)mainTablePK)) {
            this.subEntitiesPersisters.forEach((c, subPersister) -> joinColumnPerSubPersister.put(subPersister, subPersister.getMapping().getTargetTable().getPrimaryKey()));
        } else {
            this.subEntitiesPersisters.forEach((c, subPersister) -> {
                Key.KeyBuilder reverseKey = this.projectPrimaryKey((Key)rightColumn, (ConfiguredRelationalPersister<? extends C, I>)subPersister);
                joinColumnPerSubPersister.put(subPersister, reverseKey.build());
            });
        }
        if (loadSeparately) {
            this.subEntitiesPersisters.forEach((c, subPersister) -> sourcePersister.getEntityJoinTree().addMergeJoin(joinName, new FirstPhaseRelationLoader(subPersister.getMapping().getIdMapping(), this, DIFFERED_ENTITY_LOADER), leftColumn, (Key)joinColumnPerSubPersister.get(subPersister), EntityJoinTree.JoinType.OUTER));
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, DIFFERED_ENTITY_LOADER));
            return null;
        }
        return this.join(sourcePersister.getEntityJoinTree(), joinName, propertyAccessor, leftColumn, rightColumn, beanRelationFixer);
    }

    private <MAINTABLE extends Table<MAINTABLE>, SUBTABLE extends Table<SUBTABLE>, JOINID> Key.KeyBuilder<SUBTABLE, Object> projectPrimaryKey(Key<MAINTABLE, JOINID> rightColumn, ConfiguredRelationalPersister<? extends C, I> subPersister) {
        EntityMapping subTypeMapping = subPersister.getMapping();
        Key.KeyBuilder reverseKey = Key.from((Fromable)subTypeMapping.getTargetTable());
        rightColumn.getColumns().forEach(col -> {
            Column column = subTypeMapping.getTargetTable().addColumn(col.getExpression(), col.getJavaType());
            subTypeMapping.addShadowColumnSelect(column);
            reverseKey.addColumn((JoinLink)column);
        });
        return reverseKey;
    }

    private <SRC, SRCID, T1 extends Table<T1>, T2 extends Table<T2>, JOINCOLTYPE> String join(EntityJoinTree<SRC, SRCID> entityJoinTree, String leftStrategyName, Accessor<SRC, ?> propertyAccessor, Key<T1, JOINCOLTYPE> leftJoinColumn, Key<T2, JOINCOLTYPE> rightJoinColumn, BeanRelationFixer<SRC, C> beanRelationFixer) {
        KeepOrderSet commonColumns = new KeepOrderSet();
        commonColumns.addAll(this.mainPersister.getMapping().getSelectableColumns());
        commonColumns.addAll(rightJoinColumn.getColumns());
        Set commonColumnsNames = commonColumns.stream().map(JoinLink::getExpression).collect(Collectors.toSet());
        HashSet<ConfiguredRelationalPersister<C, I>> subPersisters = new HashSet<ConfiguredRelationalPersister<C, I>>(this.subEntitiesPersisters.values());
        KeepOrderSet nonCommonColumns = new KeepOrderSet();
        subPersisters.forEach(subPersister -> nonCommonColumns.addAll((Collection)subPersister.getMainTable().getColumns()));
        nonCommonColumns.removeIf(c -> commonColumnsNames.contains(c.getName()));
        Union subPersistersUnion = new Union(new Query[0]);
        String entityTypeDiscriminatorName = "clazz_";
        QueryStatement.PseudoColumn discriminatorPseudoColumn = subPersistersUnion.registerColumn(entityTypeDiscriminatorName, Integer.class);
        MutableInt discriminatorComputer = new MutableInt();
        subPersisters.forEach(arg_0 -> TablePerClassPolymorphismPersister.lambda$join$20(discriminatorComputer, entityTypeDiscriminatorName, subPersistersUnion, (Set)commonColumns, nonCommonColumns, arg_0));
        Hanger.Holder createdJoinHolder = new Hanger.Holder();
        String relationJoinName = entityJoinTree.addJoin(leftStrategyName, parent -> {
            TablePerClassPolymorphicRelationJoinNode relationJoinNode = new TablePerClassPolymorphicRelationJoinNode(parent, subPersistersUnion, (Accessor<?, ?>)propertyAccessor, leftJoinColumn, rightJoinColumn, EntityJoinTree.JoinType.OUTER, subPersistersUnion.getColumns(), this.mainPersister.getClassToPersist().getSimpleName(), new EntityInflater.EntityMappingAdapter(this.mainPersister.getMapping()), beanRelationFixer, (QueryStatement.PseudoColumn<Integer>)discriminatorPseudoColumn);
            createdJoinHolder.set(relationJoinNode);
            return relationJoinNode;
        });
        this.addTablePerClassPolymorphicSubPersistersJoins(entityJoinTree, relationJoinName, (TablePerClassPolymorphicRelationJoinNode)createdJoinHolder.get(), subPersisters);
        return relationJoinName;
    }

    private <SRC, SRCID, V extends C, T1 extends Table<T1>, T2 extends Table<T2>> void addTablePerClassPolymorphicSubPersistersJoins(EntityJoinTree<SRC, SRCID> entityJoinTree, String mainPolymorphicJoinNodeName, TablePerClassPolymorphicRelationJoinNode<C, T1, ?, I> mainPersisterJoin, Set<ConfiguredRelationalPersister<? extends C, I>> subPersisters) {
        Key.KeyBuilder leftKey = Key.from((Fromable)mainPersisterJoin.getRightTable());
        this.mainPersister.getMainTable().getPrimaryKey().getColumns().forEach(pkCol -> {
            JoinLink selectable = (JoinLink)Iterables.find(mainPersisterJoin.getColumnsToSelect(), selectableColumn -> selectableColumn.getExpression().equals(pkCol.getName()));
            leftKey.addColumn(selectable);
        });
        MutableInt discriminatorComputer = new MutableInt();
        subPersisters.forEach(subPersister -> {
            ConfiguredRelationalPersister localSubPersister = subPersister;
            entityJoinTree.addMergeJoin(mainPolymorphicJoinNodeName, new EntityMerger.EntityMergerAdapter(localSubPersister.getMapping()), leftKey.build(), subPersister.getMainTable().getPrimaryKey(), EntityJoinTree.JoinType.OUTER, joinNode -> {
                PolymorphicMergeJoinRowConsumer joinRowConsumer = new PolymorphicMergeJoinRowConsumer((MergeJoinNode)joinNode, localSubPersister.getMapping());
                mainPersisterJoin.addSubPersisterJoin(joinRowConsumer, discriminatorComputer.increment());
                return joinRowConsumer;
            });
        });
    }

    private <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOneWithSeparateLoading(EntityJoinTree<SRC, SRCID> entityJoinTree, String leftStrategyName, Key<T1, JOINID> leftJoinColumn, Key<T2, JOINID> rightJoinColumn, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters) {
        Union subPersistersUnion = new Union(new Query[0]);
        String entityTypeDiscriminatorName = "clazz_";
        subPersistersUnion.registerColumn(entityTypeDiscriminatorName, Integer.class);
        PrimaryKey primaryKey = this.mainPersister.getMainTable().getPrimaryKey();
        primaryKey.getColumns().forEach(column -> subPersistersUnion.registerColumn(column.getExpression(), column.getJavaType(), column.getExpression()));
        MutableInt discriminatorComputer = new MutableInt();
        HashMap subtypeSelectorPerDiscriminatorValue = new HashMap();
        subPersisters.forEach(subPersister -> {
            Query subEntityQuery = new Query((Fromable)subPersister.getMapping().getTargetTable());
            int discriminatorValue = discriminatorComputer.increment();
            subtypeSelectorPerDiscriminatorValue.put(discriminatorValue, subPersister);
            subEntityQuery.select(String.valueOf(discriminatorValue), Integer.class).as(entityTypeDiscriminatorName);
            subPersistersUnion.unionAll(subEntityQuery);
            rightJoinColumn.getColumns().forEach(column -> subEntityQuery.select(column.getExpression(), column.getJavaType()));
            primaryKey.getColumns().forEach(column -> subEntityQuery.select(column.getName(), column.getJavaType()));
        });
        rightJoinColumn.getColumns().forEach(column -> subPersistersUnion.registerColumn(column.getExpression(), column.getJavaType(), column.getExpression()));
        QueryStatement.PseudoTable pseudoTable = subPersistersUnion.asPseudoTable("unioned_" + this.mainPersister.getClassToPersist().getSimpleName());
        QueryStatement.PseudoColumn discriminatorPseudoColumn = (QueryStatement.PseudoColumn)pseudoTable.findColumn(entityTypeDiscriminatorName);
        KeepOrderSet primaryKeyPseudoColumns = new KeepOrderSet();
        primaryKey.getColumns().forEach(arg_0 -> TablePerClassPolymorphismPersister.lambda$joinAsOneWithSeparateLoading$31((Set)primaryKeyPseudoColumns, pseudoTable, arg_0));
        TablePerClassFirstPhaseRelationLoader tablePerClassFirstPhaseRelationLoader = new TablePerClassFirstPhaseRelationLoader(this.mainPersister.getMapping().getIdMapping(), (SelectExecutor)this, DIFFERED_ENTITY_LOADER, subtypeSelectorPerDiscriminatorValue, discriminatorPseudoColumn, (Set)primaryKeyPseudoColumns);
        Key.KeyBuilder rightJoinLinkBuilder = Key.from((Fromable)pseudoTable);
        rightJoinColumn.getColumns().forEach(column -> rightJoinLinkBuilder.addColumn((JoinLink)pseudoTable.findColumn(column.getExpression())));
        String createdJoinName = entityJoinTree.addMergeJoin(leftStrategyName, tablePerClassFirstPhaseRelationLoader, leftJoinColumn, rightJoinLinkBuilder.build(), EntityJoinTree.JoinType.OUTER);
        subPersisters.forEach(subPersister -> {
            EntityJoinTree subEntityJoinTree = subPersister.getEntityJoinTree();
            subEntityJoinTree.giveTables().forEach(table -> {
                PersisterBuilderContext.CURRENT.get();
                entityJoinTree.addTableToIncludeToDDL((Table<?>)table);
            });
        });
        return createdJoinName;
    }

    private static /* synthetic */ void lambda$joinAsOneWithSeparateLoading$31(Set primaryKeyPseudoColumns, QueryStatement.PseudoTable pseudoTable, Column column) {
        primaryKeyPseudoColumns.add(pseudoTable.findColumn(column.getName()));
    }

    private static /* synthetic */ void lambda$join$20(MutableInt discriminatorComputer, String entityTypeDiscriminatorName, Union subPersistersUnion, Set commonColumns, KeepOrderSet nonCommonColumns, ConfiguredRelationalPersister subPersister) {
        Query subEntityQuery = new Query((Fromable)subPersister.getMapping().getTargetTable());
        subEntityQuery.select(String.valueOf(discriminatorComputer.increment()), Integer.class).as(entityTypeDiscriminatorName);
        subPersistersUnion.unionAll(subEntityQuery);
        commonColumns.forEach(column -> {
            subEntityQuery.select(column.getExpression(), column.getJavaType());
            subPersistersUnion.registerColumn(column.getExpression(), column.getJavaType());
        });
        nonCommonColumns.forEach(column -> {
            Object expression = subPersister.getMapping().getSelectableColumns().contains(column) ? new Selectable.SimpleSelectable(column.getName(), column.getJavaType()) : Operators.cast((String)null, (Class)column.getJavaType());
            subEntityQuery.select((Selectable)expression, column.getName());
            subPersistersUnion.registerColumn(column.getName(), column.getJavaType());
        });
    }

    private /* synthetic */ void lambda$computeEntitiesPerPersister$11(Map entitiesPerType, Object entity) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(entity);
            }
        });
    }

    private /* synthetic */ void lambda$doUpdate$7(Map entitiesPerType, Duo payload) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            Object entity = Objects.preventNull((Object)payload.getLeft(), (Object)payload.getRight());
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(payload);
            }
        });
    }

    private class TablePerClassFirstPhaseRelationLoader
    extends FirstPhaseRelationLoader<C, I> {
        private final QueryStatement.PseudoColumn<Integer> discriminatorColumn;
        private final Map<Integer, SelectExecutor<? extends C, I>> subtypeSelectorPerDiscriminatorValue;
        private final Set<QueryStatement.PseudoColumn<?>> primaryKeyPseudoColumns;

        private TablePerClassFirstPhaseRelationLoader(IdMapping<C, I> subEntityIdMapping, SelectExecutor<C, I> selectExecutor, ThreadLocal<Queue<Set<RelationIds<Object, C, I>>>> relationIdsHolder, Map<Integer, SelectExecutor<? extends C, I>> subtypeSelectorPerDiscriminatorValue, QueryStatement.PseudoColumn<Integer> discriminatorColumn, Set<QueryStatement.PseudoColumn<?>> primaryKeyPseudoColumns) {
            super(subEntityIdMapping, selectExecutor, relationIdsHolder);
            this.discriminatorColumn = discriminatorColumn;
            this.subtypeSelectorPerDiscriminatorValue = subtypeSelectorPerDiscriminatorValue;
            this.primaryKeyPseudoColumns = primaryKeyPseudoColumns;
        }

        @Override
        protected void fillCurrentRelationIds(ColumnedRow columnedRow, C bean) {
            Integer discriminator = (Integer)columnedRow.get(this.discriminatorColumn);
            SelectExecutor subSelectExecutor = this.subtypeSelectorPerDiscriminatorValue.get(discriminator);
            if (subSelectExecutor != null) {
                Object id = this.idMapping.getIdentifierAssembler().assemble(columnedRow);
                this.addToCurrentIdsHolder(bean, subSelectExecutor, id);
            }
        }

        private <D extends C> void addToCurrentIdsHolder(C bean, SelectExecutor<D, I> subSelectExecutor, I id) {
            Set relationIds = (Set)((Queue)this.relationIdsHolder.get()).peek();
            RelationIds e = new RelationIds(subSelectExecutor, arg_0 -> ((IdAccessor)this.idMapping.getIdAccessor()).getId(arg_0), bean, id);
            relationIds.add(e);
        }

        @Override
        public Set<Selectable<?>> getSelectableColumns() {
            HashSet result = new HashSet(this.primaryKeyPseudoColumns);
            result.add(this.discriminatorColumn);
            return result;
        }
    }
}

