/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;

public class RelationJoinNode<C, T1 extends Fromable, T2 extends Fromable, JOINTYPE, I>
extends AbstractJoinNode<C, T1, T2, JOINTYPE> {
    private final EntityInflater<C, I> entityInflater;
    private final Accessor<?, ?> propertyAccessor;
    private final BeanRelationFixer<Object, C> beanRelationFixer;
    private final Function<ColumnedRow, ?> relationIdentifierProvider;

    RelationJoinNode(JoinNode<?, T1> parent, Accessor<?, C> propertyAccessor, JoinLink<T1, JOINTYPE> leftJoinColumn, JoinLink<T2, JOINTYPE> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias, EntityInflater<C, I> entityInflater, BeanRelationFixer<?, C> beanRelationFixer, @Nullable Function<ColumnedRow, ?> relationIdentifierProvider) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias);
        this.entityInflater = entityInflater;
        this.propertyAccessor = propertyAccessor;
        this.beanRelationFixer = beanRelationFixer;
        this.relationIdentifierProvider = relationIdentifierProvider;
    }

    @VisibleForTesting
    public RelationJoinNode(JoinNode<?, T1> parent, Accessor<?, ?> propertyAccessor, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias, EntityInflater<C, I> entityInflater, BeanRelationFixer<?, C> beanRelationFixer, @Nullable Function<ColumnedRow, ?> relationIdentifierProvider) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias);
        this.entityInflater = entityInflater;
        this.propertyAccessor = propertyAccessor;
        this.beanRelationFixer = beanRelationFixer;
        this.relationIdentifierProvider = relationIdentifierProvider;
    }

    RelationJoinNode(JoinNode<?, T1> parent, Accessor<?, ?> propertyAccessor, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias, EntityInflater<C, I> entityInflater, BeanRelationFixer<?, C> beanRelationFixer, @Nullable Function<ColumnedRow, ?> relationIdentifierProvider, IdentityHashMap<JoinLink<?, ?>, JoinLink<?, ?>> columnClones) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias, columnClones);
        this.entityInflater = entityInflater;
        this.propertyAccessor = propertyAccessor;
        this.beanRelationFixer = beanRelationFixer;
        this.relationIdentifierProvider = relationIdentifierProvider;
    }

    public EntityInflater<C, ?> getEntityInflater() {
        return this.entityInflater;
    }

    public Accessor<?, ?> getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public Class<C> getEntityType() {
        return this.entityInflater.getEntityType();
    }

    BeanRelationFixer<Object, C> getBeanRelationFixer() {
        return this.beanRelationFixer;
    }

    public Function<ColumnedRow, ?> getRelationIdentifierProvider() {
        return this.relationIdentifierProvider;
    }

    public RelationJoinRowConsumer<C, I> toConsumer(JoinNode<C, T2> joinNode) {
        return new DefaultRelationJoinRowConsumer<C, I>(joinNode, this.entityInflater, this.beanRelationFixer, this.relationIdentifierProvider, this.getConsumptionListener());
    }

    static final class BasicEntityCache
    implements EntityCache {
        private final Map<Class, Map<Object, Object>> entityCache = new HashMap<Class, Map<Object, Object>>();

        BasicEntityCache() {
        }

        @Override
        public <C> C computeIfAbsent(Class<C> clazz, Object identifier, Supplier<C> factory) {
            Map classInstanceCacheByIdentifier = this.entityCache.computeIfAbsent(clazz, k -> new HashMap());
            return (C)classInstanceCacheByIdentifier.computeIfAbsent(identifier, k -> factory.get());
        }
    }

    @FunctionalInterface
    public static interface EntityCache {
        public <C> C computeIfAbsent(Class<C> var1, Object var2, Supplier<C> var3);
    }

    static class DefaultRelationJoinRowConsumer<C, I>
    implements RelationJoinRowConsumer<C, I> {
        private final JoinNode<C, ?> joinNode;
        private final Class<C> entityType;
        private final Function<ColumnedRow, I> identifierProvider;
        private final BeanRelationFixer<Object, C> beanRelationFixer;
        private final Function<ColumnedRow, ?> relationIdentifierComputer;
        private final RowTransformer<C> rowTransformer;
        @Nullable
        private final EntityTreeJoinNodeConsumptionListener<C> consumptionListener;

        DefaultRelationJoinRowConsumer(JoinNode<C, ?> joinNode, EntityInflater<C, I> entityInflater, BeanRelationFixer<Object, C> beanRelationFixer, @Nullable Function<ColumnedRow, ?> relationIdentifierComputer, @Nullable EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
            this.joinNode = joinNode;
            this.entityType = entityInflater.getEntityType();
            this.identifierProvider = entityInflater::giveIdentifier;
            this.beanRelationFixer = beanRelationFixer;
            this.relationIdentifierComputer = (Function)Objects.preventNull(relationIdentifierComputer, this.identifierProvider);
            this.rowTransformer = entityInflater.getRowTransformer();
            this.consumptionListener = consumptionListener;
        }

        public JoinNode<C, ?> getNode() {
            return this.joinNode;
        }

        RowTransformer<C> getRowTransformer() {
            return this.rowTransformer;
        }

        @Override
        public C applyRelatedEntity(Object parentJoinEntity, ColumnedRow row, EntityTreeInflater.TreeInflationContext context) {
            I rightIdentifier = this.identifierProvider.apply(row);
            EntityTreeInflater.RelationIdentifier eventuallyApplied = new EntityTreeInflater.RelationIdentifier(parentJoinEntity, this.entityType, this.relationIdentifierComputer.apply(row), this);
            if (rightIdentifier != null) {
                Object rightEntity = context.giveEntityFromCache(this.entityType, rightIdentifier, () -> this.rowTransformer.transform(row));
                if (context.isTreatedOrAppend(eventuallyApplied)) {
                    this.beanRelationFixer.apply(parentJoinEntity, rightEntity);
                    if (this.consumptionListener != null) {
                        this.consumptionListener.onNodeConsumption(rightEntity, row);
                    }
                }
                return (C)rightEntity;
            }
            return null;
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }

    public static interface RelationJoinRowConsumer<C, I>
    extends JoinRowConsumer {
        public C applyRelatedEntity(Object var1, ColumnedRow var2, EntityTreeInflater.TreeInflationContext var3);
    }
}

