/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityMappingWrapper;
import org.codefilarete.stalactite.engine.runtime.FirstPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.RelationIds;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SecondPhaseRelationLoader;
import org.codefilarete.stalactite.engine.runtime.SingleTablePolymorphismEntitySelector;
import org.codefilarete.stalactite.engine.runtime.SingleTablePolymorphismSelectExecutor;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;

public class SingleTablePolymorphismPersister<C, I, T extends Table<T>, DTYPE>
extends AbstractPolymorphismPersister<C, I> {
    private static final ThreadLocal<Queue<Set<RelationIds<Object, Object, Object>>>> DIFFERED_ENTITY_LOADER = new ThreadLocal();
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
    private final SingleTablePolymorphismSelectExecutor<C, I, T, DTYPE> selectExecutor;

    public SingleTablePolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, ConnectionProvider connectionProvider, Dialect dialect, final Column<T, DTYPE> discriminatorColumn, final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
        super(mainPersister, subEntitiesPersisters, new SingleTablePolymorphismEntitySelector(mainPersister.getMapping().getIdMapping().getIdentifierAssembler(), subEntitiesPersisters, discriminatorColumn, polymorphismPolicy, mainPersister.getEntityJoinTree(), connectionProvider, dialect));
        this.mainPersister = mainPersister;
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        Mapping.ShadowColumnValueProvider discriminatorValueProvider = new Mapping.ShadowColumnValueProvider<C, T>(){

            public Set<Column<T, Object>> getColumns() {
                return Arrays.asHashSet((Object[])new Column[]{discriminatorColumn});
            }

            public Map<Column<T, Object>, Object> giveValue(C bean) {
                HashMap result = new HashMap();
                result.put(discriminatorColumn, polymorphismPolicy.getDiscriminatorValue(bean.getClass()));
                return result;
            }
        };
        this.subEntitiesPersisters.values().forEach(arg_0 -> SingleTablePolymorphismPersister.lambda$new$0((Mapping.ShadowColumnValueProvider)discriminatorValueProvider, arg_0));
        subEntitiesPersisters.forEach((type, persister) -> mainPersister.copyRootJoinsTo(persister.getEntityJoinTree(), "ROOT"));
        this.selectExecutor = new SingleTablePolymorphismSelectExecutor<C, I, T, DTYPE>(mainPersister, subEntitiesPersisters, discriminatorColumn, polymorphismPolicy, connectionProvider, dialect);
    }

    @Override
    public void registerRelation(ValueAccessPoint<C> relation, ConfiguredRelationalPersister<?, ?> persister) {
        this.criteriaSupport.registerRelation(relation, persister);
    }

    @Override
    public Column getColumn(List<? extends ValueAccessPoint<?>> accessorChain) {
        return this.criteriaSupport.getRootConfiguration().giveColumn(accessorChain);
    }

    @Override
    public Set<Class<? extends C>> getSupportedEntityTypes() {
        HashSet result = new HashSet();
        this.subEntitiesPersisters.forEach((c, p) -> {
            if (p instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)p)).getSupportedEntityTypes());
            } else if (p instanceof PersisterWrapper && ((PersisterWrapper)p).getDeepestSurrogate() instanceof PolymorphicPersister) {
                result.addAll(((PolymorphicPersister)((Object)((PersisterWrapper)p).getDeepestSurrogate())).getSupportedEntityTypes());
            } else {
                result.add((Class)c);
            }
        });
        return result;
    }

    public Collection<Table> giveImpliedTables() {
        Set subTables = this.subEntitiesPersisters.values().stream().flatMap(p -> p.giveImpliedTables().stream()).collect(Collectors.toSet());
        return Collections.cat((Collection[])new Collection[]{this.mainPersister.giveImpliedTables(), subTables});
    }

    public PersisterListenerCollection<C, I> getPersisterListener() {
        return this.mainPersister.getPersisterListener();
    }

    public I getId(C entity) {
        return (I)this.mainPersister.getId(entity);
    }

    public void insert(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(InsertExecutor::insert);
    }

    public void updateById(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(UpdateExecutor::updateById);
    }

    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        differencesIterable.forEach(arg_0 -> this.lambda$update$6((Map)entitiesPerType, arg_0));
        entitiesPerType.forEach((updateExecutor, adhocEntities) -> updateExecutor.update((Iterable)adhocEntities, allColumnsStatement));
    }

    public Set<C> select(Iterable<I> ids) {
        return this.selectExecutor.select(ids);
    }

    public void delete(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::delete);
    }

    public void deleteById(Iterable<? extends C> entities) {
        Map<EntityPersister<C, I>, Set<C>> entitiesPerType = this.computeEntitiesPerPersister(entities);
        entitiesPerType.forEach(DeleteExecutor::deleteById);
    }

    private Map<EntityPersister<C, I>, Set<C>> computeEntitiesPerPersister(Iterable<? extends C> entities) {
        KeepOrderMap entitiesPerType = new KeepOrderMap();
        entities.forEach(arg_0 -> this.lambda$computeEntitiesPerPersister$10((Map)entitiesPerType, arg_0));
        return entitiesPerType;
    }

    @Override
    public <E, ID> void copyRootJoinsTo(EntityJoinTree<E, ID> entityJoinTree, String joinName) {
        throw new UnsupportedOperationException();
    }

    public void addPersistListener(PersistListener<? extends C> persistListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addPersistListener(persistListener));
    }

    public void addInsertListener(InsertListener<? extends C> insertListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addInsertListener(insertListener));
    }

    public void addUpdateListener(UpdateListener<? extends C> updateListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addUpdateListener(updateListener));
    }

    public void addUpdateByIdListener(UpdateByIdListener<? extends C> updateByIdListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addUpdateByIdListener(updateByIdListener));
    }

    public void addSelectListener(SelectListener<? extends C, I> selectListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addSelectListener(selectListener));
    }

    public void addDeleteListener(DeleteListener<? extends C> deleteListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addDeleteListener(deleteListener));
    }

    public void addDeleteByIdListener(DeleteByIdListener<? extends C> deleteListener) {
        this.subEntitiesPersisters.values().forEach(p -> p.addDeleteByIdListener(deleteListener));
    }

    public EntityMapping<C, I, T> getMapping() {
        return new EntityMappingWrapper<C, I, T>(this.mainPersister.getMapping()){

            @Override
            public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
                SingleTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addTransformerListener(listener));
            }

            @Override
            public void addShadowColumnInsert(Mapping.ShadowColumnValueProvider<C, T> provider) {
                SingleTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addShadowColumnInsert(provider));
            }

            @Override
            public void addShadowColumnUpdate(Mapping.ShadowColumnValueProvider<C, T> provider) {
                SingleTablePolymorphismPersister.this.subEntitiesPersisters.values().forEach(p -> p.getMapping().addShadowColumnUpdate(provider));
            }
        };
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsOne(RelationalEntityPersister<SRC, SRCID> sourcePersister, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, String rightTableAlias, BeanRelationFixer<SRC, C> beanRelationFixer, boolean optional, boolean loadSeparately) {
        if (loadSeparately) {
            SingleTableFirstPhaseRelationLoader singleTableFirstPhaseRelationLoader = new SingleTableFirstPhaseRelationLoader(this.mainPersister.getMapping().getIdMapping(), this.selectExecutor, DIFFERED_ENTITY_LOADER, this.discriminatorColumn, this.subEntitiesPersisters::get);
            String createdJoinNodeName = sourcePersister.getEntityJoinTree().addMergeJoin("ROOT", singleTableFirstPhaseRelationLoader, leftColumn, rightColumn, optional ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER);
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, DIFFERED_ENTITY_LOADER));
            return createdJoinNodeName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), "ROOT", this.mainPersister, leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()), beanRelationFixer, this.polymorphismPolicy, this.discriminatorColumn);
    }

    @Override
    public <SRC, T1 extends Table<T1>, T2 extends Table<T2>, SRCID, JOINID> String joinAsMany(RelationalEntityPersister<SRC, SRCID> sourcePersister, Key<T1, JOINID> leftColumn, Key<T2, JOINID> rightColumn, BeanRelationFixer<SRC, C> beanRelationFixer, @Nullable BiFunction<Row, ColumnedRow, Object> duplicateIdentifierProvider, String joinName, Set<? extends Column<T2, Object>> selectableColumns, boolean optional, boolean loadSeparately) {
        PrimaryKey mainTablePK = this.mainPersister.getMapping().getTargetTable().getPrimaryKey();
        HashMap joinColumnPerSubPersister = new HashMap();
        if (rightColumn.equals((Object)mainTablePK)) {
            this.subEntitiesPersisters.forEach((c, subPersister) -> joinColumnPerSubPersister.put(subPersister, subPersister.getMapping().getTargetTable().getPrimaryKey()));
        } else {
            this.subEntitiesPersisters.forEach((c, subPersister) -> {
                Key.KeyBuilder reverseKey = this.projectPrimaryKey((Key)rightColumn, (ConfiguredRelationalPersister<? extends C, I>)subPersister);
                joinColumnPerSubPersister.put(subPersister, reverseKey.build());
            });
        }
        if (loadSeparately) {
            SingleTableFirstPhaseRelationLoader singleTableFirstPhaseRelationLoader = new SingleTableFirstPhaseRelationLoader(this.mainPersister.getMapping().getIdMapping(), this.selectExecutor, DIFFERED_ENTITY_LOADER, this.discriminatorColumn, this.subEntitiesPersisters::get);
            String createdJoinNodeName = sourcePersister.getEntityJoinTree().addMergeJoin(joinName, singleTableFirstPhaseRelationLoader, leftColumn, rightColumn, EntityJoinTree.JoinType.OUTER);
            sourcePersister.addSelectListener(new SecondPhaseRelationLoader(beanRelationFixer, DIFFERED_ENTITY_LOADER));
            return createdJoinNodeName;
        }
        return this.join(sourcePersister.getEntityJoinTree(), joinName, this.mainPersister, leftColumn, rightColumn, new HashSet(this.subEntitiesPersisters.values()), beanRelationFixer, this.polymorphismPolicy, this.discriminatorColumn);
    }

    private <MAINTABLE extends Table<MAINTABLE>, SUBTABLE extends Table<SUBTABLE>, JOINID> Key.KeyBuilder<SUBTABLE, Object> projectPrimaryKey(Key<MAINTABLE, JOINID> rightColumn, ConfiguredRelationalPersister<? extends C, I> subPersister) {
        EntityMapping subTypeMapping = subPersister.getMapping();
        Key.KeyBuilder reverseKey = Key.from((Fromable)subTypeMapping.getTargetTable());
        rightColumn.getColumns().forEach(col -> {
            Column column = subTypeMapping.getTargetTable().addColumn(col.getExpression(), col.getJavaType());
            subTypeMapping.addShadowColumnSelect(column);
            reverseKey.addColumn((JoinLink)column);
        });
        return reverseKey;
    }

    private <SRC, SRCID, U extends C, T1 extends Table<T1>, T2 extends Table<T2>, ID, JOINCOLTYPE> String join(EntityJoinTree<SRC, SRCID> entityJoinTree, String leftStrategyName, final ConfiguredRelationalPersister<U, ID> mainPersister, Key<T1, JOINCOLTYPE> leftJoinColumn, Key<T2, JOINCOLTYPE> rightJoinColumn, final Set<ConfiguredRelationalPersister<? extends U, ID>> subPersisters, BeanRelationFixer<SRC, U> beanRelationFixer, final PolymorphismPolicy.SingleTablePolymorphism<U, DTYPE> polymorphismPolicy, Column<T2, DTYPE> discriminatorColumn) {
        Hanger.Holder createdJoinHolder = new Hanger.Holder();
        String relationJoinName = entityJoinTree.addJoin(leftStrategyName, parent -> {
            SingleTablePolymorphicRelationJoinNode polymorphicRelationJoinNode = new SingleTablePolymorphicRelationJoinNode<U, T1, T2, JOINCOLTYPE, ID, DTYPE>((JoinNode)parent, leftJoinColumn, rightJoinColumn, EntityJoinTree.JoinType.OUTER, mainPersister.getMainTable().getColumns(), null, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), beanRelationFixer, discriminatorColumn){

                @Override
                public SingleTablePolymorphicRelationJoinNode.SingleTablePolymorphicRelationJoinRowConsumer toConsumer(ColumnedRow columnedRow) {
                    SingleTablePolymorphicRelationJoinNode.SingleTablePolymorphicRelationJoinRowConsumer joinTablePolymorphicRelationJoinRowConsumer = super.toConsumer(columnedRow);
                    SingleTablePolymorphismPersister.this.addSingleTableSubPersistersJoin(mainPersister, this, subPersisters, columnedRow, polymorphismPolicy);
                    return joinTablePolymorphicRelationJoinRowConsumer;
                }
            };
            createdJoinHolder.set((Object)polymorphicRelationJoinNode);
            return polymorphicRelationJoinNode;
        });
        return relationJoinName;
    }

    private <U, V extends U, T1 extends Table<T1>, T2 extends Table<T2>, JOINCOLTYPE, ID> void addSingleTableSubPersistersJoin(ConfiguredRelationalPersister<U, ID> mainPersister, SingleTablePolymorphicRelationJoinNode<U, T1, T2, JOINCOLTYPE, ID, DTYPE> mainPersisterJoin, Set<ConfiguredRelationalPersister<? extends U, ID>> subPersisters, ColumnedRow columnedRow, PolymorphismPolicy.SingleTablePolymorphism<U, DTYPE> polymorphismPolicy) {
        subPersisters.forEach(subPersister -> {
            ConfiguredRelationalPersister localSubPersister = subPersister;
            EntityJoinTree.PolymorphicMergeJoinRowConsumer joinRowConsumer = new EntityJoinTree.PolymorphicMergeJoinRowConsumer(new EntityJoinTree.PolymorphicEntityInflater(mainPersister, localSubPersister), columnedRow);
            mainPersisterJoin.addSubPersisterJoin(localSubPersister, joinRowConsumer, polymorphismPolicy.getDiscriminatorValue(localSubPersister.getClassToPersist()));
        });
    }

    private /* synthetic */ void lambda$computeEntitiesPerPersister$10(Map entitiesPerType, Object entity) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(entity);
            }
        });
    }

    private /* synthetic */ void lambda$update$6(Map entitiesPerType, Duo payload) {
        this.subEntitiesPersisters.values().forEach(persister -> {
            Object entity = Objects.preventNull((Object)payload.getLeft(), (Object)payload.getRight());
            if (persister.getClassToPersist().isInstance(entity)) {
                entitiesPerType.computeIfAbsent(persister, p -> new KeepOrderSet()).add(payload);
            }
        });
    }

    private static /* synthetic */ void lambda$new$0(Mapping.ShadowColumnValueProvider discriminatorValueProvider, ConfiguredRelationalPersister subclassPersister) {
        subclassPersister.getMapping().addShadowColumnInsert(discriminatorValueProvider);
    }

    private class SingleTableFirstPhaseRelationLoader
    extends FirstPhaseRelationLoader<C, I> {
        private final Column<T, DTYPE> discriminatorColumn;
        private final Function<Class, SelectExecutor> subtypeSelectors;
        private final Set<DTYPE> discriminatorValues;

        private SingleTableFirstPhaseRelationLoader(IdMapping<C, I> subEntityIdMapping, SingleTablePolymorphismSelectExecutor<C, I, T, DTYPE> selectExecutor, ThreadLocal<Queue<Set<RelationIds<Object, C, I>>>> relationIdsHolder, Column<T, DTYPE> discriminatorColumn, Function<Class, SelectExecutor> subtypeSelectors) {
            super(subEntityIdMapping, selectExecutor, relationIdsHolder);
            this.discriminatorColumn = discriminatorColumn;
            this.subtypeSelectors = subtypeSelectors;
            this.discriminatorValues = (Set)Iterables.collect(SingleTablePolymorphismPersister.this.polymorphismPolicy.getSubClasses(), conf -> SingleTablePolymorphismPersister.this.polymorphismPolicy.getDiscriminatorValue(conf.getEntityType()), HashSet::new);
        }

        @Override
        protected void fillCurrentRelationIds(Row row, Object bean, ColumnedRow columnedRow) {
            Object discriminator = columnedRow.getValue(this.discriminatorColumn, row);
            if (this.discriminatorValues.contains(discriminator)) {
                Set relationIds = (Set)((Queue)this.relationIdsHolder.get()).peek();
                Object id = this.idMapping.getIdentifierAssembler().assemble(row, columnedRow);
                relationIds.add(new RelationIds<Object, Object, Object>(this.giveSelector(discriminator), arg_0 -> ((IdAccessor)this.idMapping.getIdAccessor()).getId(arg_0), bean, id));
            }
        }

        @Override
        public Set<Selectable<Object>> getSelectableColumns() {
            HashSet<Selectable<Object>> result = new HashSet<Selectable<Object>>(this.idMapping.getIdentifierAssembler().getColumns());
            result.add((Selectable<Object>)this.discriminatorColumn);
            return result;
        }

        private SelectExecutor giveSelector(DTYPE discriminator) {
            return this.subtypeSelectors.apply(SingleTablePolymorphismPersister.this.polymorphismPolicy.getClass(discriminator));
        }
    }
}

