/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.cycle;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.ManyToManyCycleLoader;

public class ManyToManyCycleConfigurer<TRGT>
extends PersisterBuilderImpl.PostInitializer<TRGT> {
    private final Set<RelationConfigurer<?, ?, ?>> relations = new LinkedHashSet();

    public ManyToManyCycleConfigurer(Class<TRGT> entityType) {
        super(entityType);
    }

    public <SRC> void addCycleSolver(String relationIdentifier, ManyToManyRelationConfigurer<SRC, TRGT, ?, ?, ? extends Collection<TRGT>, ? extends Collection<SRC>> cascadeManyConfigurer) {
        this.relations.add(new RelationConfigurer(relationIdentifier, cascadeManyConfigurer));
    }

    @Override
    public void consume(ConfiguredRelationalPersister<TRGT, ?> targetPersister) {
        this.registerRelationLoader(targetPersister);
    }

    private <SRC, TRGTID> void registerRelationLoader(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        ManyToManyCycleLoader manyToManyCycleLoader = new ManyToManyCycleLoader(targetPersister);
        targetPersister.addSelectListener(manyToManyCycleLoader);
        this.relations.forEach(c -> {
            String tableAlias = ((RelationConfigurer)c).relationName.replaceAll("\\W", "_");
            CascadeConfigurationResult configurationResult = ((RelationConfigurer)c).cascadeManyConfigurer.configureWithSelectIn2Phases(tableAlias, targetPersister, manyToManyCycleLoader.buildRowReader(((RelationConfigurer)c).relationName));
            manyToManyCycleLoader.addRelation(((RelationConfigurer)c).relationName, configurationResult);
        });
    }

    private class RelationConfigurer<SRC, SRCID, TRGTID> {
        private final String relationName;
        private final ManyToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID, Collection<TRGT>, Collection<SRC>> cascadeManyConfigurer;

        public RelationConfigurer(String relationName, ManyToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID, ? extends Collection<TRGT>, ? extends Collection<SRC>> cascadeManyConfigurer) {
            this.relationName = relationName;
            this.cascadeManyConfigurer = cascadeManyConfigurer;
        }
    }
}

