/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.HashSet;
import java.util.Map;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelation;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.polymorphism.PolymorphismBuilder;
import org.codefilarete.stalactite.engine.configurer.polymorphism.PolymorphismPersisterBuilder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.OneToOneCycleConfigurer;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

abstract class AbstractPolymorphicPersisterBuilder<C, I, T extends Table<T>>
implements PolymorphismBuilder<C, I, T> {
    protected final PolymorphismPolicy<C> polymorphismPolicy;
    protected final ConfiguredRelationalPersister<C, I> mainPersister;
    protected final AbstractIdentification<C, I> identification;
    protected final ColumnBinderRegistry columnBinderRegistry;
    protected final NamingConfiguration namingConfiguration;

    protected static void assertNullOrEqual(Table table1, Table table2) {
        HashSet availableTables = Arrays.asHashSet((Object[])new Table[]{table1, table2});
        availableTables.remove(null);
        if (availableTables.size() > 1) {
            class TableAppender
            extends StringAppender {
                TableAppender() {
                }

                public StringAppender cat(Object o) {
                    if (o instanceof Table) {
                        return super.cat((Object)((Table)o).getName());
                    }
                    return super.cat(o);
                }
            }
            throw new MappingConfigurationException("Table declared in inheritance is different from given one in embeddable properties override : " + new TableAppender().ccat(availableTables, ", "));
        }
    }

    protected AbstractPolymorphicPersisterBuilder(PolymorphismPolicy<C> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration) {
        this.polymorphismPolicy = polymorphismPolicy;
        this.identification = identification;
        this.mainPersister = mainPersister;
        this.columnBinderRegistry = columnBinderRegistry;
        this.namingConfiguration = namingConfiguration;
    }

    protected <D extends C> void registerCascades(Map<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry) {
        PersisterBuilderContext.CURRENT.get().runInContext(this.mainPersister, () -> {
            for (SubEntityMappingConfiguration<C> subConfiguration : this.polymorphismPolicy.getSubClasses()) {
                ConfiguredRelationalPersister subEntityPersister = (ConfiguredRelationalPersister)persisterPerSubclass.get(subConfiguration.getEntityType());
                if (subConfiguration.getPolymorphismPolicy() != null) {
                    this.registerPolymorphismCascades(persisterPerSubclass, dialect, connectionConfiguration, persisterRegistry, subConfiguration, subEntityPersister);
                }
                this.registerRelationCascades(subConfiguration, dialect, connectionConfiguration, persisterRegistry, subEntityPersister);
            }
        });
    }

    private <D extends C> void registerPolymorphismCascades(Map<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry, SubEntityMappingConfiguration<D> subConfiguration, ConfiguredRelationalPersister<D, I> subEntityPersister) {
        this.assertSubPolymorphismIsSupported(subConfiguration.getPolymorphismPolicy());
        ConfiguredRelationalPersister<D, I> subclassPersister = this.buildSubPolymorphicPersister(subEntityPersister, subConfiguration.getPolymorphismPolicy(), dialect, connectionConfiguration, persisterRegistry);
        persisterPerSubclass.put(subConfiguration.getEntityType(), subclassPersister);
    }

    abstract void assertSubPolymorphismIsSupported(PolymorphismPolicy<? extends C> var1);

    private <D extends C> ConfiguredRelationalPersister<D, I> buildSubPolymorphicPersister(ConfiguredRelationalPersister<D, I> subPersister, PolymorphismPolicy<D> subPolymorphismPolicy, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry) {
        PolymorphismPersisterBuilder polymorphismPersisterBuilder = new PolymorphismPersisterBuilder(subPolymorphismPolicy, (AbstractIdentification.Identification)this.identification, subPersister, this.columnBinderRegistry, subPersister.getMapping().getPropertyToColumn(), subPersister.getMapping().getReadonlyPropertyToColumn(), subPersister.getMapping().getReadConverters(), subPersister.getMapping().getWriteConverters(), this.namingConfiguration);
        return polymorphismPersisterBuilder.build(dialect, connectionConfiguration, persisterRegistry);
    }

    private <D extends C, TRGT> void registerRelationCascades(SubEntityMappingConfiguration<D> entityMappingConfiguration, Dialect dialect, ConnectionConfiguration connectionConfiguration, PersisterRegistry persisterRegistry, ConfiguredRelationalPersister<D, I> subEntityPersister) {
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        for (OneToOneRelation oneToOneRelation : entityMappingConfiguration.getOneToOnes()) {
            OneToOneRelationConfigurer oneToOneRelationConfigurer = new OneToOneRelationConfigurer(oneToOneRelation, subEntityPersister, dialect, connectionConfiguration, persisterRegistry, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getJoinColumnNamingStrategy());
            String relationName = AccessorDefinition.giveDefinition(oneToOneRelation.getTargetProvider()).getName();
            if (currentBuilderContext.isCycling(oneToOneRelation.getTargetMappingConfiguration())) {
                Class targetEntityType = oneToOneRelation.getTargetMappingConfiguration().getEntityType();
                OneToOneCycleConfigurer cycleSolver = (OneToOneCycleConfigurer)Iterables.find(currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof OneToOneCycleConfigurer && ((OneToOneCycleConfigurer)p).getEntityType() == targetEntityType);
                if (cycleSolver == null) {
                    cycleSolver = new OneToOneCycleConfigurer(targetEntityType);
                    currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
                }
                cycleSolver.addCycleSolver(relationName, oneToOneRelationConfigurer);
                continue;
            }
            oneToOneRelationConfigurer.configure(relationName, new PersisterBuilderImpl(oneToOneRelation.getTargetMappingConfiguration()), oneToOneRelation.isFetchSeparately());
        }
        for (OneToManyRelation oneToManyRelation : entityMappingConfiguration.getOneToManys()) {
            final OneToManyRelationConfigurer oneToManyRelationConfigurer = new OneToManyRelationConfigurer(oneToManyRelation, subEntityPersister, dialect, connectionConfiguration, persisterRegistry, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getJoinColumnNamingStrategy(), this.namingConfiguration.getAssociationTableNamingStrategy(), this.namingConfiguration.getIndexColumnNamingStrategy());
            if (currentBuilderContext.isCycling(oneToManyRelation.getTargetMappingConfiguration())) {
                PersisterBuilderImpl.PostInitializer postInitializer = new PersisterBuilderImpl.PostInitializer(oneToManyRelation.getTargetMappingConfiguration().getEntityType()){

                    public void consume(ConfiguredRelationalPersister targetPersister) {
                        oneToManyRelationConfigurer.configure((PersisterBuilderImpl)((Object)targetPersister));
                    }
                };
                PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(postInitializer);
                continue;
            }
            oneToManyRelationConfigurer.configure(new PersisterBuilderImpl(oneToManyRelation.getTargetMappingConfiguration()));
        }
        for (ElementCollectionRelation elementCollectionRelation : entityMappingConfiguration.getElementCollections()) {
            ElementCollectionRelationConfigurer elementCollectionRelationConfigurer = new ElementCollectionRelationConfigurer(elementCollectionRelation, subEntityPersister, this.namingConfiguration.getForeignKeyNamingStrategy(), this.namingConfiguration.getColumnNamingStrategy(), this.namingConfiguration.getElementCollectionTableNamingStrategy(), dialect, connectionConfiguration);
            elementCollectionRelationConfigurer.configure();
        }
    }
}

