/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.StringAppender;

public class StringAppenderWrapper
implements SQLAppender {
    private final StringAppender surrogate;
    private final DMLNameProvider dmlNameProvider;

    public StringAppenderWrapper(StringAppender stringAppender, DMLNameProvider dmlNameProvider) {
        this.surrogate = stringAppender;
        this.dmlNameProvider = dmlNameProvider;
    }

    @Override
    public StringAppenderWrapper cat(String s, String ... ss) {
        this.surrogate.cat((Object)s).cat((Object[])ss);
        return this;
    }

    @Override
    public <V> StringAppenderWrapper catValue(@Nullable Selectable<V> column, V value) {
        if (value instanceof CharSequence) {
            this.surrogate.cat((Object)"'", (Object)value.toString().replace("'", "''"), (Object)"'");
        } else if (value instanceof Column) {
            this.surrogate.cat((Object)this.dmlNameProvider.getName((Column)value));
        } else {
            this.surrogate.cat(value);
        }
        return this;
    }

    @Override
    public StringAppenderWrapper catValue(Object value) {
        if (value instanceof CharSequence) {
            this.surrogate.cat((Object)"'", (Object)value.toString().replace("'", "''"), (Object)"'");
        } else if (value instanceof Column) {
            this.surrogate.cat((Object)this.dmlNameProvider.getName((Column)value));
        } else {
            this.surrogate.cat(value);
        }
        return this;
    }

    @Override
    public StringAppenderWrapper catColumn(Column column) {
        this.surrogate.cat((Object)this.dmlNameProvider.getName(column));
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.surrogate.cutTail(length);
        return this;
    }

    @Override
    public String getSQL() {
        return this.surrogate.toString();
    }
}

