/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PreparedSQLWrapper;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringAppenderWrapper;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.MultiTableAwareDMLNameProvider;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class DeleteCommandBuilder
implements SQLBuilder,
PreparedSQLBuilder {
    private final Delete delete;
    private final Dialect dialect;
    private final MultiTableAwareDMLNameProvider dmlNameProvider;

    public DeleteCommandBuilder(Delete delete, Dialect dialect) {
        this.delete = delete;
        this.dialect = dialect;
        this.dmlNameProvider = new MultiTableAwareDMLNameProvider();
    }

    @Override
    public String toSQL() {
        return this.toSQL(new StringAppenderWrapper(new StringAppender(), this.dmlNameProvider), this.dmlNameProvider);
    }

    @Override
    public PreparedSQL toPreparedSQL() {
        PreparedSQLWrapper preparedSQLWrapper = new PreparedSQLWrapper(new StringAppenderWrapper(new StringAppender(), this.dmlNameProvider), this.dialect.getColumnBinderRegistry(), this.dmlNameProvider);
        String sql = this.toSQL(preparedSQLWrapper, this.dmlNameProvider);
        PreparedSQL result = new PreparedSQL(sql, preparedSQLWrapper.getParameterBinders());
        result.setValues(preparedSQLWrapper.getValues());
        return result;
    }

    private String toSQL(SQLAppender result, MultiTableAwareDMLNameProvider dmlNameProvider) {
        result.cat("delete from ", new String[0]);
        LinkedHashSet whereColumns = new LinkedHashSet();
        this.delete.getCriteria().forEach(c -> {
            if (c instanceof ColumnCriterion && ((ColumnCriterion)c).getColumn() instanceof Column) {
                whereColumns.add((Column)((ColumnCriterion)c).getColumn());
                Object condition = ((ColumnCriterion)c).getCondition();
                if (condition instanceof UnitaryOperator && ((UnitaryOperator)condition).getValue() instanceof Column) {
                    whereColumns.add((Column)((UnitaryOperator)condition).getValue());
                }
            }
        });
        Set additionalTables = Iterables.minus((Collection)Iterables.collect(whereColumns, Column::getTable, HashSet::new), (Collection)Arrays.asList((Object[])new Table[]{this.delete.getTargetTable()}));
        dmlNameProvider.setMultiTable(!additionalTables.isEmpty());
        result.cat(this.delete.getTargetTable().getAbsoluteName(), new String[0]).catIf(dmlNameProvider.isMultiTable(), ", ");
        Iterator iterator = additionalTables.iterator();
        while (iterator.hasNext()) {
            Table next = (Table)iterator.next();
            result.cat(next.getAbsoluteName(), new String[0]).catIf(iterator.hasNext(), ", ");
        }
        if (this.delete.getCriteria().iterator().hasNext()) {
            result.cat(" where ", new String[0]);
            WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder = this.dialect.getQuerySQLBuilderFactory().getWhereBuilderFactory().whereBuilder(this.delete.getCriteria(), dmlNameProvider);
            whereSqlBuilder.appendSQL(result);
        }
        return result.getSQL();
    }
}

