/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.ArrayList;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.StringAppenderWrapper;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.query.model.operator.Lower;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

class OperatorSQLBuilderTest {
    private final DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap());

    OperatorSQLBuilderTest() {
    }

    @Test
    public void cat_nullValue_isTransformedToIsNull() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.cat((ConditionalOperator)new ConditionalOperator<Object, Object>(){

            public void setValue(Object value) {
            }

            public boolean isNull() {
                return true;
            }
        }, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("is null");
    }

    @Test
    public void catNullValue() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catNullValue(false, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("is null");
        result = new StringAppender();
        testInstance.catNullValue(true, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("is not null");
    }

    @Test
    public void catIsNull() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catIsNull(new IsNull(), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("is null");
        result = new StringAppender();
        testInstance.catIsNull((IsNull)Operators.not((ConditionalOperator)new IsNull()), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("is not null");
        result = new StringAppender();
        IsNull isNull = new IsNull();
        isNull.setValue((Object)42);
        testInstance.catIsNull(isNull, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("is null");
    }

    @Test
    public void catLike() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catLike(new Like((CharSequence)"a"), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("like 'a'");
        result = new StringAppender();
        testInstance.catLike(Operators.contains((CharSequence)"a"), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("like '%a%'");
        result = new StringAppender();
        testInstance.catLike(Operators.startsWith((CharSequence)"a"), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("like 'a%'");
        result = new StringAppender();
        testInstance.catLike(Operators.endsWith((CharSequence)"a"), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("like '%a'");
    }

    @Test
    public void catIn() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catIn(Operators.in((Object[])new String[]{"a", "b"}), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("in ('a', 'b')");
        result = new StringAppender();
        testInstance.catIn(Operators.in((Object[])new Object[0]), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("in ()");
        result = new StringAppender();
        testInstance.cat((ConditionalOperator)Operators.in((Object[])new Object[]{null}), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("in (null)");
    }

    @Test
    public void catIn_tupled() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        Table dummyTable = new Table("dummyTable");
        Column firstName = dummyTable.addColumn("firstName", String.class);
        Column lastName = dummyTable.addColumn("lastName", String.class);
        TupleIn tupleIn = new TupleIn(new Column[]{firstName, lastName}, Arrays.asList((Object[])new Object[][]{{"John", "Doe"}, {"Jane", "Doe"}, {"Paul", "Smith"}}));
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in (('John', 'Doe'), ('Jane', 'Doe'), ('Paul', 'Smith'))");
        result = new StringAppender();
        tupleIn = new TupleIn(new Column[]{firstName, lastName}, Collections.emptyList());
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in ()");
        result = new StringAppender();
        tupleIn = new TupleIn(new Column[]{firstName, lastName}, null);
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in (null, null)");
        result = new StringAppender();
        ArrayList<Object[]> input = new ArrayList<Object[]>();
        input.add(new Object[]{"John", null});
        tupleIn = new TupleIn(new Column[]{firstName, lastName}, input);
        testInstance.cat((ConditionalOperator)tupleIn, (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("(dummyTable.firstName, dummyTable.lastName) in (('John', null))");
    }

    @Test
    public void catBetween() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catBetween(Operators.between((Object)1, (Object)2), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("between 1 and 2");
        result = new StringAppender();
        testInstance.catBetween(Operators.between((Object)1, null), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("> 1");
        result = new StringAppender();
        testInstance.catBetween(Operators.between(null, (Object)2), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("< 2");
    }

    @Test
    public void catGreater() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catGreater(Operators.gt((Object)1), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("> 1");
        result = new StringAppender();
        testInstance.catGreater((Greater)Operators.not((ConditionalOperator)Operators.gt((Object)1)), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("<= 1");
        result = new StringAppender();
        testInstance.catGreater(Operators.gteq((Object)1), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo(">= 1");
        result = new StringAppender();
        testInstance.catGreater((Greater)Operators.not((ConditionalOperator)Operators.gteq((Object)1)), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("< 1");
    }

    @Test
    public void catLower() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catLower(Operators.lt((Object)1), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("< 1");
        result = new StringAppender();
        testInstance.catLower((Lower)Operators.not((ConditionalOperator)Operators.lt((Object)1)), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo(">= 1");
        result = new StringAppender();
        testInstance.catLower(Operators.lteq((Object)1), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("<= 1");
        result = new StringAppender();
        testInstance.catLower((Lower)Operators.not((ConditionalOperator)Operators.lteq((Object)1)), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("> 1");
    }

    @Test
    public void catEquals() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        testInstance.catEquals(Operators.eq((Object)1), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("= 1");
    }

    @Test
    public void catEquals_column() {
        OperatorSQLBuilderFactory.OperatorSQLBuilder testInstance = new OperatorSQLBuilderFactory.OperatorSQLBuilder();
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        testInstance.catEquals(Operators.eq((Object)colA), (SQLAppender)new StringAppenderWrapper(result, this.dmlNameProvider), null);
        Assertions.assertThat((String)result.toString()).isEqualTo("= Toto.a");
    }
}

