/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.codefilarete.reflection.AbstractMutator;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ExceptionConverter;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.NonReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPointByMethod;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.ThreadSafeLazyInitializer;

public class MutatorByMethod<C, T>
extends AbstractMutator<C, T>
implements MutatorByMember<C, T, Method>,
ReversibleMutator<C, T>,
ValueAccessPointByMethod<C> {
    private final Method setter;
    private final Supplier<Accessor<C, T>> accessor;

    public MutatorByMethod(Method setter) {
        Reflections.ensureAccessible((AccessibleObject)setter);
        this.setter = setter;
        this.accessor = new ThreadSafeLazyInitializer<Accessor<C, T>>(){

            protected Accessor<C, T> createInstance() {
                return MutatorByMethod.this.findCompatibleAccessor();
            }
        };
    }

    MutatorByMethod(Method setter, Accessor<C, T> accessor) {
        this.setter = setter;
        this.accessor = () -> accessor;
    }

    public MutatorByMethod(Class<C> declaringClass, String setterName, Class ... argTypes) {
        this(Reflections.getMethod(declaringClass, (String)setterName, (Class[])argTypes));
    }

    @Override
    public Method getSetter() {
        return this.setter;
    }

    @Override
    public Method getMethod() {
        return this.getSetter();
    }

    @Override
    public Class<T> getPropertyType() {
        return this.getMethod().getParameterTypes()[0];
    }

    @Override
    protected void doSet(C c, T t) throws IllegalAccessException, InvocationTargetException {
        try {
            this.getSetter().invoke(c, t);
        }
        catch (RuntimeException e) {
            throw new ExceptionConverter().convertException(e, c, this, t);
        }
    }

    @Override
    protected String getSetterDescription() {
        return Reflections.toString((Method)this.getSetter());
    }

    @Override
    public Accessor<C, T> toAccessor() {
        return this.accessor.get();
    }

    private Accessor<C, T> findCompatibleAccessor() {
        String propertyName;
        Class<?> declaringClass = this.getSetter().getDeclaringClass();
        AccessorByMethod accessorByMethod = Accessors.accessorByMethod(declaringClass, propertyName = Reflections.propertyName((Method)this.getSetter()), this.getSetter().getParameterTypes()[0], this);
        if (accessorByMethod == null) {
            try {
                return Accessors.accessorByField(declaringClass, propertyName);
            }
            catch (Reflections.MemberNotFoundException e) {
                throw new NonReversibleAccessor("Can't find a mutator for " + Reflections.toString((Method)this.getSetter()), e);
            }
        }
        return accessorByMethod;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof MutatorByMethod && this.getSetterDescription().equals(((MutatorByMethod)other).getSetterDescription());
    }

    @Override
    public int hashCode() {
        return this.getSetter().hashCode();
    }
}

