/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.tool.InvocationHandlerSupport;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.SerializableThrowingBiConsumer;
import org.codefilarete.tool.function.SerializableThrowingConsumer;
import org.codefilarete.tool.function.SerializableThrowingFunction;
import org.codefilarete.tool.function.SerializableThrowingTriConsumer;
import org.codefilarete.tool.function.SerializableTriConsumer;
import org.codefilarete.tool.function.SerializableTriFunction;
import org.codefilarete.tool.function.ThrowingBiConsumer;
import org.codefilarete.tool.function.ThrowingConsumer;
import org.codefilarete.tool.reflect.MethodDispatcher;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBiFunction;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class MethodReferenceDispatcher
extends MethodDispatcher {
    private static final MethodReferenceCapturer METHOD_REFERENCE_CAPTURER = new MethodReferenceCapturer();

    public <X, R> MethodReferenceDispatcher redirect(SerializableFunction<X, R> methodToCapture, Supplier<R> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (Object[] args) -> codeToInvoke.get());
        return this;
    }

    public <X, R> MethodReferenceDispatcher redirect(SerializableFunction<X, R> methodToCapture, Runnable codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (Object[] args) -> codeToInvoke.run());
        return this;
    }

    public <X, A, R> MethodReferenceDispatcher redirect(SerializableBiFunction<X, A, R> methodToCapture, Function<A, R> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (Object[] args) -> codeToInvoke.apply(args[0]));
        return this;
    }

    public <X, A, R> MethodReferenceDispatcher redirect(SerializableBiFunction<X, A, R> methodToCapture, Consumer<A> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (Object[] args) -> codeToInvoke.accept(args[0]));
        return this;
    }

    public <X, A, B, R> MethodReferenceDispatcher redirect(SerializableTriFunction<X, A, B, R> methodToCapture, BiFunction<A, B, R> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (Object[] args) -> codeToInvoke.apply(args[0], args[1]));
        return this;
    }

    public <X, A, B, R> MethodReferenceDispatcher redirect(SerializableTriFunction<X, A, B, R> methodToCapture, BiConsumer<A, B> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (Object[] args) -> codeToInvoke.accept(args[0], args[1]));
        return this;
    }

    public <X> MethodReferenceDispatcher redirect(SerializableConsumer<X> methodToCapture, Runnable codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (proxy, m, args) -> {
            codeToInvoke.run();
            return null;
        }, true);
        return this;
    }

    public <X, A> MethodReferenceDispatcher redirect(SerializableBiConsumer<X, A> methodToCapture, Consumer<A> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (proxy, m, args) -> {
            codeToInvoke.accept(args[0]);
            return null;
        }, true);
        return this;
    }

    public <X, A, B> MethodReferenceDispatcher redirect(SerializableTriConsumer<X, A, B> methodToCapture, BiConsumer<A, B> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(methodToCapture), (proxy, method1, args) -> {
            codeToInvoke.accept(args[0], args[1]);
            return null;
        }, true);
        return this;
    }

    public <X, R, E extends Throwable> MethodReferenceDispatcher redirectThrower(SerializableThrowingFunction<X, R, E> methodToCapture, Supplier<R> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(MethodReferences.buildSerializedLambda(methodToCapture)), (Object[] args) -> codeToInvoke.get());
        return this;
    }

    public <X, E extends Throwable> MethodReferenceDispatcher redirectThrower(SerializableThrowingConsumer<X, E> methodToCapture, Runnable codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(MethodReferences.buildSerializedLambda(methodToCapture)), (Object[] args) -> codeToInvoke.run());
        return this;
    }

    public <X, A, E extends Throwable> MethodReferenceDispatcher redirectThrower(SerializableThrowingBiConsumer<X, A, E> methodToCapture, ThrowingConsumer<A, E> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(MethodReferences.buildSerializedLambda(methodToCapture)), (Object[] args) -> codeToInvoke.accept(args[0]));
        return this;
    }

    public <X, A, B, E extends Throwable> MethodReferenceDispatcher redirectThrower(SerializableThrowingTriConsumer<X, A, B, E> methodToCapture, ThrowingBiConsumer<A, B, E> codeToInvoke) {
        this.addInterceptor(METHOD_REFERENCE_CAPTURER.findMethod(MethodReferences.buildSerializedLambda(methodToCapture)), (Object[] args) -> codeToInvoke.accept(args[0], args[1]));
        return this;
    }

    public <X> MethodReferenceDispatcher redirect(Class<X> interfazz, X extensionDelegate) {
        return (MethodReferenceDispatcher)super.redirect(interfazz, extensionDelegate);
    }

    public <X> MethodReferenceDispatcher redirect(Class<X> interfazz, X extensionDelegate, boolean returnProxy) {
        return (MethodReferenceDispatcher)super.redirect(interfazz, extensionDelegate, returnProxy);
    }

    public <X> MethodReferenceDispatcher redirect(Class<X> interfazz, X extensionDelegate, Object returningMethodsTarget) {
        return (MethodReferenceDispatcher)super.redirect(interfazz, extensionDelegate, returningMethodsTarget);
    }

    private void addInterceptor(Method method, ArgsDigester argsDigester) {
        this.addInterceptor(method, (p, m, args) -> argsDigester.digest(args), false);
    }

    private void addInterceptor(Method method, ArgsConsumer argsConsumer) {
        this.addInterceptor(method, (p, m, args) -> {
            argsConsumer.consume(args);
            return Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(method.getReturnType(), null);
        }, true);
    }

    private void addInterceptor(Method method, InvocationHandler invocationHandler, boolean returnProxy) {
        Object proxy = Reflections.newProxy(method.getDeclaringClass(), (InvocationHandler)new InvocationHandlerSupport(invocationHandler), (Class[])new Class[0]);
        this.interceptors.put(this.giveSignature(method), new MethodDispatcher.Interceptor(method, proxy, returnProxy));
    }

    @FunctionalInterface
    private static interface ArgsDigester<R> {
        public R digest(Object ... var1) throws Throwable;
    }

    @FunctionalInterface
    private static interface ArgsConsumer {
        public void consume(Object ... var1) throws Throwable;
    }
}

