/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.AbstractMutator;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.MutatorByField;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.exception.NotImplementedException;

public class ExceptionConverter {
    protected RuntimeException convertException(Throwable t, Object target, AbstractReflector reflector, Object ... args) {
        if (t instanceof NullPointerException) {
            NullPointerException nullPointerException = new NullPointerException("Cannot invoke " + this.getReflectorDescription(reflector) + " on null instance");
            nullPointerException.initCause(t);
            return nullPointerException;
        }
        if (t instanceof InvocationTargetException || t instanceof IllegalAccessException) {
            return Exceptions.asRuntimeException((Throwable)t);
        }
        if (t instanceof IllegalArgumentException) {
            if ("wrong number of arguments".equals(t.getMessage())) {
                return this.convertWrongNumberOfArguments(reflector, args);
            }
            if ("object is not an instance of declaring class".equals(t.getMessage())) {
                return this.convertObjectIsNotAnInstanceOfDeclaringClass(target, reflector);
            }
            if (t.getMessage().startsWith("Can not set")) {
                return this.convertCannotSetFieldToObject(target, reflector, args.length > 0 ? args[0] : null);
            }
            if ("argument type mismatch".equals(t.getMessage())) {
                return this.convertArgumentTypeMismatch((IllegalArgumentException)t, reflector, args);
            }
            return Exceptions.asRuntimeException((Throwable)t);
        }
        return Exceptions.asRuntimeException((Throwable)t);
    }

    private IllegalArgumentException convertWrongNumberOfArguments(AbstractReflector reflector, Object ... args) {
        String message = "wrong number of arguments for " + this.getReflectorDescription(reflector);
        if (reflector instanceof AccessorByMethod) {
            message = message + this.giveMessageForWrongNumberOfArguments(((AccessorByMethod)reflector).getGetter(), args);
        }
        return new IllegalArgumentException(message);
    }

    public String giveMessageForWrongNumberOfArguments(Method method, Object[] args) {
        TypeAppender parameterFormatter = new TypeAppender(100);
        parameterFormatter.ccat(method.getParameterTypes(), ", ");
        return ": expected " + parameterFormatter.toString() + " but " + (Arrays.isEmpty((Object[])args) ? "none" : new StringAppender(100).ccat(args, (Object)", ").wrap((Object)"(", (Object)")")) + " was given";
    }

    private IllegalArgumentException convertObjectIsNotAnInstanceOfDeclaringClass(Object target, AbstractReflector reflector) {
        String message = "object is not an instance of declaring class";
        if (reflector instanceof AccessorByMember || reflector instanceof MutatorByMember) {
            Object member = reflector instanceof AccessorByMember ? ((AccessorByMember)((Object)reflector)).getGetter() : ((MutatorByMember)((Object)reflector)).getSetter();
            Class<?> declaringClass = member.getDeclaringClass();
            message = message + this.giveMessageForConvertObjectIsNotAnInstanceOfDeclaringClass(target, declaringClass);
        }
        return new IllegalArgumentException(message);
    }

    public String giveMessageForConvertObjectIsNotAnInstanceOfDeclaringClass(Object target, Class<?> declaringClass) {
        return ": expected " + Reflections.toString(declaringClass) + " but " + Reflections.toString(target.getClass()) + " was given";
    }

    private RuntimeException convertCannotSetFieldToObject(Object target, AbstractReflector reflector, Object arg) {
        Field getter;
        if (reflector instanceof AccessorByField) {
            getter = ((AccessorByField)reflector).getGetter();
        } else if (reflector instanceof MutatorByField) {
            getter = ((MutatorByField)reflector).getSetter();
        } else {
            throw new NotImplementedException(reflector.getClass() + " is not handled by this convertor");
        }
        if (Reflections.findField(target.getClass(), (String)getter.getName()) == null) {
            return new IllegalArgumentException("Field " + Reflections.toString((Field)getter) + " doesn't exist in " + Reflections.toString(target.getClass()));
        }
        if (!target.getClass().isAssignableFrom(getter.getDeclaringClass())) {
            return new IllegalArgumentException("Field " + Reflections.toString((Field)getter) + " cannot be applied on instance of type " + Reflections.toString(target.getClass()));
        }
        if (!getter.getType().isInstance(arg)) {
            return new IllegalArgumentException("Field " + Reflections.toString((Field)getter) + " of type " + Reflections.toString(getter.getType()) + " is not compatible with " + (arg == null ? "null" : Reflections.toString(arg.getClass())));
        }
        return new RuntimeException("Can not set " + arg + " to " + target);
    }

    private IllegalArgumentException convertArgumentTypeMismatch(IllegalArgumentException t, AbstractReflector reflector, Object ... args) {
        if (reflector instanceof MutatorByMethod) {
            TypeAppender parameterFormatter = new TypeAppender(100);
            parameterFormatter.cat(this.getReflectorDescription(reflector), " expects ").ccat((Object[])((MutatorByMethod)reflector).getMethod().getParameterTypes(), (Object)", ").cat((Object)" as argument, but ").ccat((Iterable)Iterables.collectToList((Iterable)Arrays.asList((Object[])args), Object::getClass), (Object)", ").cat((Object)" was given");
            throw new IllegalArgumentException(parameterFormatter.toString());
        }
        throw t;
    }

    private String getReflectorDescription(AbstractReflector reflector) {
        if (reflector instanceof AbstractAccessor) {
            return ((AbstractAccessor)reflector).getGetterDescription();
        }
        if (reflector instanceof AbstractMutator) {
            return ((AbstractMutator)reflector).getSetterDescription();
        }
        throw new IllegalArgumentException("Unknown reflector " + reflector);
    }

    private static class TypeAppender
    extends StringAppender {
        private TypeAppender(int capacity) {
            super(capacity);
        }

        public StringAppender cat(Object s) {
            return s instanceof Class ? super.cat((Object)Reflections.toString((Class)((Class)s))) : super.cat(s);
        }
    }
}

