/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.Array;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.ArrayMutator;
import org.codefilarete.reflection.ReversibleAccessor;

public class ArrayAccessor<C>
extends AbstractAccessor<C, C>
implements ReversibleAccessor<C, C> {
    private int index;
    private final ArrayMutator<C> mutator;

    public ArrayAccessor() {
        this.mutator = new ArrayMutator(0, this);
    }

    public ArrayAccessor(int index) {
        this.index = index;
        this.mutator = new ArrayMutator(index, this);
    }

    ArrayAccessor(int index, ArrayMutator<C> mutator) {
        this.index = index;
        this.mutator = mutator;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public C get(C[] cs) {
        return cs[this.getIndex()];
    }

    @Override
    public C get(C c) {
        try {
            return this.doGet(c);
        }
        catch (RuntimeException t) {
            this.handleException(t, c, new Object[0]);
            return null;
        }
    }

    @Override
    protected C doGet(C cs) {
        return (C)Array.get(cs, this.getIndex());
    }

    @Override
    protected String getGetterDescription() {
        return "array accessor for index " + this.index;
    }

    public ArrayMutator<C> toMutator() {
        return this.mutator;
    }
}

