/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByField;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointByField;
import org.codefilarete.tool.Reflections;

public class AccessorByField<C, T>
extends AbstractAccessor<C, T>
implements AccessorByMember<C, T, Field>,
ReversibleAccessor<C, T>,
ValueAccessPointByField {
    private final Field field;
    private final Mutator<C, T> mutator;

    public AccessorByField(Field field) {
        Reflections.ensureAccessible((AccessibleObject)field);
        this.field = field;
        this.mutator = new MutatorByField(field, this);
    }

    AccessorByField(Field field, Mutator<C, T> mutator) {
        this.field = field;
        this.mutator = mutator;
    }

    @Override
    public Field getGetter() {
        return this.field;
    }

    @Override
    public Field getField() {
        return this.getGetter();
    }

    @Override
    public Class<T> getPropertyType() {
        return this.field.getType();
    }

    @Override
    protected T doGet(C c) throws IllegalAccessException {
        return (T)this.getGetter().get(c);
    }

    @Override
    public String getGetterDescription() {
        return "accessor for field " + Reflections.toString((Field)this.getGetter());
    }

    @Override
    public Mutator<C, T> toMutator() {
        return this.mutator;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof AccessorByField && this.getGetter().toString().equals(((AccessorByField)other).getGetter().toString());
    }

    @Override
    public int hashCode() {
        return this.getGetter().hashCode();
    }
}

