/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Nullable;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinitionDefiner;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointByField;
import org.codefilarete.reflection.ValueAccessPointByMethod;
import org.codefilarete.reflection.ValueAccessPointByMethodReference;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Iterables;

public class AccessorDefinition {
    private static final MethodReferenceCapturer METHOD_REFERENCE_CAPTURER = new MethodReferenceCapturer();
    private final Class declaringClass;
    private final String name;
    private final Class memberType;

    public static AccessorDefinition giveDefinition(ValueAccessPoint<?> accessPoint) {
        AccessorDefinition result;
        if (accessPoint instanceof AccessorDefinitionDefiner) {
            result = ((AccessorDefinitionDefiner)accessPoint).asAccessorDefinition();
        } else if (accessPoint instanceof AccessorChain) {
            result = AccessorDefinition.giveDefinition((AccessorChain)accessPoint);
        } else if (accessPoint instanceof PropertyAccessor) {
            result = AccessorDefinition.giveDefinition(((PropertyAccessor)accessPoint).getAccessor());
        } else if (accessPoint instanceof AbstractReflector) {
            result = AccessorDefinition.giveDefinition((AbstractReflector)((Object)accessPoint));
        } else {
            throw new UnsupportedOperationException("Accessor type is unsupported to compute its definition : " + (accessPoint == null ? "null" : Reflections.toString(accessPoint.getClass())));
        }
        return result;
    }

    public static AccessorDefinition giveDefinition(Method method) {
        return new AccessorDefinition(method.getDeclaringClass(), Reflections.propertyName((Method)method), method.getReturnType());
    }

    public static AccessorDefinition giveDefinition(Field field) {
        return new AccessorDefinition(field.getDeclaringClass(), field.getName(), field.getType());
    }

    private static AccessorDefinition giveDefinition(AbstractReflector o) {
        String memberName = null;
        Class<Object> declarator = null;
        Class<?> memberType = null;
        if (o instanceof ValueAccessPointByField) {
            Field member = ((ValueAccessPointByField)((Object)o)).getField();
            memberName = member.getName();
            declarator = member.getDeclaringClass();
            memberType = member.getType();
        } else if (o instanceof ValueAccessPointByMethod) {
            Method member = ((ValueAccessPointByMethod)((Object)o)).getMethod();
            memberName = Reflections.propertyName((String)member.getName());
            declarator = member.getDeclaringClass();
            memberType = o instanceof Accessor ? member.getReturnType() : member.getParameterTypes()[0];
        } else if (o instanceof ValueAccessPointByMethodReference) {
            memberName = Reflections.propertyName((String)((ValueAccessPointByMethodReference)((Object)o)).getMethodName());
            declarator = ((ValueAccessPointByMethodReference)((Object)o)).getDeclaringClass();
            Method method = METHOD_REFERENCE_CAPTURER.findMethod(((ValueAccessPointByMethodReference)((Object)o)).getSerializedLambda());
            memberType = o instanceof Accessor ? method.getReturnType() : method.getParameterTypes()[0];
        }
        return new AccessorDefinition(declarator, memberName, memberType);
    }

    private static AccessorDefinition giveDefinition(AccessorChain<?, ?> o) {
        StringAppender stringAppender = new StringAppender(){

            public StringAppender cat(Object s) {
                if (s instanceof Accessor) {
                    return super.cat((Object)AccessorDefinition.giveDefinition((Accessor)s).getName());
                }
                return super.cat(s);
            }
        };
        stringAppender.ccat(o.getAccessors(), (Object)".");
        Accessor firstAccessor = (Accessor)Iterables.first(o.getAccessors());
        Accessor lastAccessor = (Accessor)Iterables.last(o.getAccessors());
        return new AccessorDefinition(AccessorDefinition.giveDefinition(firstAccessor).getDeclaringClass(), stringAppender.toString(), AccessorDefinition.giveDefinition(lastAccessor).getMemberType());
    }

    public static String toString(@Nullable ValueAccessPoint<?> o) {
        String result;
        if (o == null) {
            result = "null";
        } else if (o instanceof AccessorByMember) {
            result = AccessorDefinition.toString(((AccessorByMember)o).getGetter());
        } else if (o instanceof AccessorByMethodReference) {
            result = MethodReferences.toMethodReferenceString(((AccessorByMethodReference)o).getMethodReference());
        } else if (o instanceof MutatorByMember) {
            result = AccessorDefinition.toString(((MutatorByMember)o).getSetter());
        } else if (o instanceof MutatorByMethodReference) {
            result = MethodReferences.toMethodReferenceString(((MutatorByMethodReference)o).getMethodReference());
        } else if (o instanceof PropertyAccessor) {
            result = AccessorDefinition.toString(((PropertyAccessor)o).getAccessor());
        } else if (o instanceof AccessorChain) {
            StringAppender chainPrint = new StringAppender();
            ((AccessorChain)o).getAccessors().forEach(accessor -> chainPrint.cat((Object)AccessorDefinition.toString((Accessor)accessor)).cat((Object)" > "));
            result = chainPrint.cutTail(3).toString();
        } else {
            throw new UnsupportedOperationException("Don't know how find out member definition for " + Reflections.toString(o.getClass()));
        }
        return result;
    }

    private static String toString(Member member) {
        String result = member instanceof Method ? Reflections.toString((Method)((Method)member)) : Reflections.toString((Field)((Field)member));
        return result;
    }

    public static String toString(Collection<ValueAccessPoint<?>> accessPoints) {
        StringAppender chainPrint = new StringAppender();
        accessPoints.forEach(accessor -> chainPrint.cat((Object)AccessorDefinition.toString(accessor)).cat((Object)" > "));
        return chainPrint.cutTail(3).toString();
    }

    public AccessorDefinition(Class declaringClass, String name, Class memberType) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.memberType = memberType;
    }

    public <T> Class<T> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AccessorDefinition) {
            AccessorDefinition other = (AccessorDefinition)obj;
            return other.getDeclaringClass().equals(this.getDeclaringClass()) && other.getName().equals(this.getName()) && other.getMemberType().equals(this.getMemberType());
        }
        return false;
    }

    public int hashCode() {
        int result = this.declaringClass.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.memberType.hashCode();
        return result;
    }

    public Class getMemberType() {
        return this.memberType;
    }

    public String toString() {
        return Reflections.toString(this.getDeclaringClass()) + '.' + this.getName();
    }
}

