/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.invoke.SerializedLambda;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.MethodReferences;
import org.codefilarete.reflection.ValueAccessPointByMethodReference;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class AccessorByMethodReference<C, T>
extends AbstractAccessor<C, T>
implements ValueAccessPointByMethodReference<C> {
    private final SerializableFunction<C, T> methodReference;
    private final String methodReferenceSignature;
    private final String methodName;
    private final Class declaringClass;
    private final SerializedLambda serializedLambda;
    private final Class propertyType;

    public AccessorByMethodReference(SerializableFunction<C, T> methodReference) {
        this.methodReference = methodReference;
        this.serializedLambda = MethodReferences.buildSerializedLambda(methodReference);
        this.methodName = this.serializedLambda.getImplMethodName();
        this.declaringClass = MethodReferences.giveImplementingClass(this.serializedLambda);
        this.propertyType = MethodReferenceCapturer.giveArgumentTypes(this.serializedLambda).getReturnType();
        this.methodReferenceSignature = Reflections.toString((Class)this.declaringClass).concat("::").concat(this.methodName);
    }

    public SerializableFunction<C, T> getMethodReference() {
        return this.methodReference;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<C> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public SerializedLambda getSerializedLambda() {
        return this.serializedLambda;
    }

    @Override
    protected T doGet(C c) {
        return (T)this.methodReference.apply(c);
    }

    @Override
    protected String getGetterDescription() {
        return this.methodReferenceSignature;
    }

    @Override
    public Class<T> getPropertyType() {
        return this.propertyType;
    }
}

