/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.AbstractMutator;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorChainMutator;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByField;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.reflect.MethodDispatcher;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public final class Accessors {
    private static final MethodReferenceCapturer methodCapturer = new MethodReferenceCapturer();

    @Nullable
    public static <C, T> AccessorByMethod<C, T> accessorByMethod(Field field) {
        Method getter = Accessors.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
        return getter == null ? null : new AccessorByMethod(getter);
    }

    @Nullable
    public static <C, T> AccessorByMethod<C, T> accessorByMethod(Class clazz, String propertyName) {
        Field field = Reflections.findField((Class)clazz, (String)propertyName);
        return Accessors.accessorByMethod(field);
    }

    @Nullable
    public static <C, T> AccessorByMethod<C, T> accessorByMethod(Class clazz, String propertyName, Class<T> inputType) {
        Method getter = Accessors.findGetter(clazz, propertyName, inputType);
        return getter == null ? null : new AccessorByMethod(getter);
    }

    @Nullable
    public static <C, T> AccessorByMethod<C, T> accessorByMethod(Class clazz, String propertyName, Class<T> inputType, Mutator<C, T> mutator) {
        Method getter = Accessors.findGetter(clazz, propertyName, inputType);
        if (getter == null) {
            return null;
        }
        Reflections.ensureAccessible((AccessibleObject)getter);
        return new AccessorByMethod<C, T>(getter, new Object[getter.getParameterTypes().length], mutator);
    }

    @Nullable
    private static <T> Method findGetter(Class clazz, String propertyName, Class<T> inputType) {
        String capitalizedProperty = Strings.capitalize((CharSequence)propertyName);
        String methodPrefix = Boolean.TYPE.isAssignableFrom(inputType) || Boolean.class.isAssignableFrom(inputType) ? "is" : "get";
        return Reflections.findMethod((Class)clazz, (String)(methodPrefix + capitalizedProperty), (Class[])new Class[0]);
    }

    public static <C, T> AccessorByMethodReference<C, T> accessorByMethodReference(SerializableFunction<C, T> getter) {
        return new AccessorByMethodReference<C, T>(getter);
    }

    public static <C, T> ReversibleAccessor<C, T> accessorByMethodReference(SerializableFunction<C, T> getter, final SerializableBiConsumer<C, T> setter) {
        final AccessorByMethodReference<C, T> fallback = new AccessorByMethodReference<C, T>(getter);
        return (ReversibleAccessor)new MethodDispatcher().redirect(ReversibleAccessor.class, (Object)new ReversibleAccessor<C, T>(){

            @Override
            public Mutator<C, T> toMutator() {
                return new MutatorByMethodReference(setter);
            }

            @Override
            public T get(C o) {
                return fallback.get(o);
            }
        }).fallbackOn(fallback).build(ReversibleAccessor.class);
    }

    public static <C, T> AccessorByField<C, T> accessorByField(Field field) {
        return new AccessorByField(field);
    }

    public static <C, T> AccessorByField<C, T> accessorByField(Class<C> clazz, String propertyName) {
        Field propertyField = Reflections.getField(clazz, (String)propertyName);
        return Accessors.accessorByField(propertyField);
    }

    public static <C, T> MutatorByMethod<C, T> mutatorByMethod(Field field) {
        return new MutatorByMethod(Reflections.getMethod(field.getDeclaringClass(), (String)("set" + Strings.capitalize((CharSequence)field.getName())), (Class[])new Class[]{field.getType()}));
    }

    @Nullable
    public static <C, T> MutatorByMethod<C, T> mutatorByMethod(Class<C> clazz, String propertyName) {
        Field field = Reflections.getField(clazz, (String)propertyName);
        try {
            return Accessors.mutatorByMethod(field);
        }
        catch (Reflections.MemberNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public static <C, T> MutatorByMethod<C, T> mutatorByMethod(Class<C> clazz, String propertyName, Class<T> inputType) {
        String capitalizedProperty = Strings.capitalize((CharSequence)propertyName);
        Method setter = Reflections.findMethod(clazz, (String)("set" + capitalizedProperty), (Class[])new Class[]{inputType});
        return setter == null ? null : new MutatorByMethod(setter);
    }

    @Nullable
    public static <C, T> MutatorByMethod<C, T> mutatorByMethod(Class<C> clazz, String propertyName, Class<T> inputType, Accessor<C, T> accessor) {
        String capitalizedProperty = Strings.capitalize((CharSequence)propertyName);
        Method setter = Reflections.findMethod(clazz, (String)("set" + capitalizedProperty), (Class[])new Class[]{inputType});
        if (setter == null) {
            return null;
        }
        Reflections.ensureAccessible((AccessibleObject)setter);
        return new MutatorByMethod<C, T>(setter, accessor);
    }

    public static <C, T> MutatorByMethodReference<C, T> mutatorByMethodReference(SerializableBiConsumer<C, T> setter) {
        return new MutatorByMethodReference<C, T>(setter);
    }

    public static <C, T> MutatorByField<C, T> mutatorByField(Field field) {
        return new MutatorByField(field);
    }

    public static <C, T> MutatorByField<C, T> mutatorByField(Class clazz, String propertyName) {
        Field propertyField = Reflections.getField((Class)clazz, (String)propertyName);
        return Accessors.mutatorByField(propertyField);
    }

    public static <C, T> MutatorByField<C, T> mutatorByField(Class clazz, String propertyName, Accessor<C, T> accessor) {
        Field propertyField = Reflections.getField((Class)clazz, (String)propertyName);
        Reflections.ensureAccessible((AccessibleObject)propertyField);
        return new MutatorByField<C, T>(propertyField, accessor);
    }

    public static Field wrappedField(AccessorByMethod accessorByMethod) {
        Method getter = accessorByMethod.getGetter();
        return Reflections.wrappedField((Method)getter);
    }

    public static <C, T> PropertyAccessor<C, T> propertyAccessor(Field field) {
        return new PropertyAccessor(new AccessorByField(field), new MutatorByField(field));
    }

    public static <C, T> PropertyAccessor<C, T> propertyAccessor(Class<C> clazz, String propertyName) {
        AccessorByMember propertyGetter = Accessors.accessor(clazz, propertyName);
        MutatorByMember propertySetter = Accessors.mutator(clazz, propertyName, propertyGetter.getPropertyType());
        return new PropertyAccessor(propertyGetter, propertySetter);
    }

    public static <C, T, M extends Member> AccessorByMember<C, T, M> accessor(Class<C> clazz, String propertyName) {
        AbstractAccessor propertyGetter = Accessors.accessorByMethod(clazz, propertyName);
        if (propertyGetter == null) {
            propertyGetter = new AccessorByField(Reflections.getField(clazz, (String)propertyName));
        }
        return propertyGetter;
    }

    public static <C, T, M extends Member> AccessorByMember<C, T, M> accessor(Class<C> clazz, String propertyName, Class<T> propertyType) {
        AbstractAccessor propertyGetter = Accessors.accessorByMethod(clazz, propertyName, propertyType);
        if (propertyGetter == null) {
            Field foundField = Reflections.getField(clazz, (String)propertyName);
            if (!Reflections.isAssignableFrom(propertyType, foundField.getType())) {
                throw new Reflections.MemberNotFoundException(Reflections.toString(clazz) + "." + propertyName, "Member type doesn't match expected one for field " + Reflections.toString((Field)foundField) + ": expected " + Reflections.toString(propertyType) + " but is " + Reflections.toString(foundField.getType()));
            }
            propertyGetter = new AccessorByField(foundField);
        }
        return propertyGetter;
    }

    public static <C, T, M extends Member> MutatorByMember<C, T, M> mutator(Class<C> clazz, String propertyName) {
        Field field = Reflections.getField(clazz, (String)propertyName);
        try {
            return Accessors.mutatorByMethod(field);
        }
        catch (Reflections.MemberNotFoundException e) {
            return new MutatorByField(field);
        }
    }

    public static <C, T, M extends Member> MutatorByMember<C, T, M> mutator(Class<C> clazz, String propertyName, Class<T> propertyType) {
        AbstractMutator propertySetter = Accessors.mutatorByMethod(clazz, propertyName, propertyType);
        if (propertySetter == null) {
            Field foundField = Reflections.getField(clazz, (String)propertyName);
            if (!Reflections.isAssignableFrom(propertyType, foundField.getType())) {
                throw new Reflections.MemberNotFoundException(Reflections.toString(clazz) + "." + propertyName, "Member type doesn't match expected one for field " + Reflections.toString((Field)foundField) + ": expected " + Reflections.toString(propertyType) + " but is " + Reflections.toString(foundField.getType()));
            }
            propertySetter = new MutatorByField(foundField);
        }
        return propertySetter;
    }

    public static <C, E> PropertyAccessor<C, E> accessor(SerializableFunction<C, E> getter) {
        AccessorByMethodReference<C, E> methodReference = Accessors.accessorByMethodReference(getter);
        return new PropertyAccessor<C, E>(methodReference, Accessors.mutator(methodReference.getDeclaringClass(), Reflections.propertyName((String)methodReference.getMethodName()), methodReference.getPropertyType()));
    }

    public static <C, E> PropertyAccessor<C, E> mutator(SerializableBiConsumer<C, E> setter) {
        MutatorByMethodReference<C, E> methodReference = Accessors.mutatorByMethodReference(setter);
        return new PropertyAccessor<C, E>(Accessors.accessor(methodReference.getDeclaringClass(), Reflections.propertyName((String)methodReference.getMethodName()), methodReference.getPropertyType()), methodReference);
    }

    public static <C, T> PropertyAccessor<C, T> accessor(Member member) {
        if (member instanceof Field) {
            return new PropertyAccessor(new AccessorByField((Field)member));
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            AbstractReflector reflector = (AbstractReflector)Reflections.onJavaBeanPropertyWrapperName((Method)method, AccessorByMethod::new, MutatorByMethod::new, AccessorByMethod::new);
            if (reflector instanceof ReversibleAccessor) {
                return new PropertyAccessor((ReversibleAccessor)((Object)reflector));
            }
            if (reflector instanceof ReversibleMutator) {
                return new PropertyAccessor((ReversibleMutator)((Object)reflector));
            }
            throw new IllegalArgumentException("Member cannot be determined as a getter or a setter : " + member);
        }
        throw new IllegalArgumentException("Member cannot be used as an accessor : " + member);
    }

    public static Class giveInputType(Mutator mutator) {
        if (mutator instanceof MutatorByMember) {
            Object member = ((MutatorByMember)mutator).getSetter();
            if (member instanceof Method) {
                return ((Method)member).getParameterTypes()[0];
            }
            if (member instanceof Field) {
                return ((Field)member).getType();
            }
            throw new UnsupportedOperationException("Mutator type is not implemented : " + mutator);
        }
        if (mutator instanceof MutatorByMethodReference) {
            return methodCapturer.findMethod(((MutatorByMethodReference)mutator).getMethodReference()).getParameterTypes()[0];
        }
        if (mutator instanceof PropertyAccessor) {
            return Accessors.giveInputType(((PropertyAccessor)mutator).getMutator());
        }
        if (mutator instanceof AccessorChainMutator) {
            return Accessors.giveInputType(((AccessorChainMutator)mutator).getMutator());
        }
        throw new UnsupportedOperationException("Mutator type is not implemented : " + mutator);
    }

    public static Class giveReturnType(Accessor accessor) {
        if (accessor instanceof AccessorByMember) {
            Object member = ((AccessorByMember)accessor).getGetter();
            if (member instanceof Method) {
                return ((Method)member).getReturnType();
            }
            if (member instanceof Field) {
                return ((Field)member).getType();
            }
            throw new UnsupportedOperationException("Mutator type is not implemented : " + accessor);
        }
        if (accessor instanceof AccessorByMethodReference) {
            return methodCapturer.findMethod(((AccessorByMethodReference)accessor).getMethodReference()).getReturnType();
        }
        if (accessor instanceof PropertyAccessor) {
            return Accessors.giveReturnType(((PropertyAccessor)accessor).getAccessor());
        }
        if (accessor instanceof AccessorChain) {
            return Accessors.giveReturnType((Accessor)Iterables.last(((AccessorChain)accessor).getAccessors()));
        }
        throw new UnsupportedOperationException("Accessor type is not implemented : " + accessor);
    }

    private Accessors() {
    }
}

