/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.reflection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.codefilarete.reflection.AbstractAccessor;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChainMutator;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class AccessorChain<C, T>
extends AbstractAccessor<C, T>
implements ReversibleAccessor<C, T> {
    public static final NullValueHandler THROW_NULLPOINTEREXCEPTION = new NullPointerExceptionThrowerOnNullValue();
    public static final NullValueHandler RETURN_NULL = new NullReturnerOnNullValue();
    public static final NullValueHandler INITIALIZE_VALUE = new ValueInitializerOnNullValue();
    private final List<Accessor<?, ?>> accessors;
    private NullValueHandler nullValueHandler = THROW_NULLPOINTEREXCEPTION;

    public static <IN, OUT> AccessorChain<IN, OUT> chain(SerializableFunction<IN, OUT> function1) {
        return new AccessorChain(new AccessorByMethodReference<IN, OUT>(function1));
    }

    public static <IN, A, OUT> AccessorChain<IN, OUT> chain(SerializableFunction<IN, A> function1, SerializableFunction<A, OUT> function2) {
        return new AccessorChain(new AccessorByMethodReference<IN, A>(function1), new AccessorByMethodReference<A, OUT>(function2));
    }

    public static <IN, A, OUT> AccessorChain<IN, OUT> chainNullSafe(SerializableFunction<IN, A> getter1, SerializableFunction<A, OUT> getter2) {
        return new AccessorChain<IN, OUT>(new Accessor[]{Accessors.accessor(getter1), Accessors.accessor(getter2)}){
            private final AccessorChainMutator<IN, Object, OUT> mutator = (AccessorChainMutator)((AccessorChain)((Object)super.toMutator())).setNullValueHandler(INITIALIZE_VALUE);

            @Override
            public AccessorChainMutator toMutator() {
                return this.mutator;
            }
        }.setNullValueHandler(RETURN_NULL);
    }

    public static <IN, A, OUT> AccessorChainMutator<IN, A, OUT> chainNullSafe(SerializableFunction<IN, A> getter, BiConsumer<A, OUT> setter) {
        AccessorChainMutator result = new AccessorChainMutator(Arrays.asList((Object[])new PropertyAccessor[]{Accessors.accessor(getter)}), setter::accept);
        result.setNullValueHandler(INITIALIZE_VALUE);
        return result;
    }

    public static <IN, OUT> AccessorChain<IN, OUT> chainNullSafe(List<? extends Accessor<?, ?>> accessors) {
        return AccessorChain.chainNullSafe(accessors, null);
    }

    public static <IN, OUT> AccessorChain<IN, OUT> chainNullSafe(List<? extends Accessor<?, ?>> accessors, final @Nullable BiFunction<Accessor, Class, Object> valueTypeDeterminer) {
        return new AccessorChain<IN, OUT>(accessors){
            private final AccessorChainMutator<IN, Object, OUT> mutator;
            {
                super(accessors);
                this.mutator = (AccessorChainMutator)((AccessorChain)((Object)super.toMutator())).setNullValueHandler(new ValueInitializerOnNullValue(valueTypeDeterminer));
            }

            @Override
            public AccessorChainMutator toMutator() {
                return this.mutator;
            }
        }.setNullValueHandler(RETURN_NULL);
    }

    public AccessorChain() {
        this(new ArrayList(5));
    }

    public AccessorChain(Accessor<?, ?> ... accessors) {
        this(Arrays.asList((Object[])accessors));
    }

    public AccessorChain(List<? extends Accessor<?, ?>> accessors) {
        this.accessors = accessors;
    }

    public List<Accessor<?, ?>> getAccessors() {
        return this.accessors;
    }

    public void add(Accessor<?, ?> accessor) {
        this.accessors.add(accessor);
    }

    public void add(Accessor<?, ?> ... accessors) {
        this.add(Arrays.asList((Object[])accessors));
    }

    public void add(Iterable<? extends Accessor<?, ?>> accessors) {
        if (accessors instanceof Collection) {
            this.accessors.addAll((Collection)accessors);
        } else {
            accessors.forEach(this::add);
        }
    }

    public AccessorChain<C, T> setNullValueHandler(NullValueHandler nullValueHandler) {
        this.nullValueHandler = nullValueHandler;
        return this;
    }

    @Override
    public T doGet(C c) {
        Object target = c;
        for (Accessor<?, ?> accessor : this.accessors) {
            C previousTarget = target;
            if ((target = accessor.get(target)) != null) continue;
            Object handlerResult = this.onNullValue(previousTarget, accessor);
            if (handlerResult == null) {
                return null;
            }
            target = handlerResult;
        }
        return (T)target;
    }

    @Nullable
    protected Object onNullValue(Object targetBean, Accessor accessor) {
        return this.nullValueHandler.consume(targetBean, accessor);
    }

    public AccessorChainMutator<C, Object, T> toMutator() {
        Accessor lastAccessor = (Accessor)Iterables.last(this.getAccessors());
        if (lastAccessor instanceof ReversibleAccessor) {
            Mutator lastMutator = ((ReversibleAccessor)lastAccessor).toMutator();
            AccessorChainMutator result = new AccessorChainMutator(Iterables.cutTail(this.getAccessors()), lastMutator);
            result.setNullValueHandler(this.nullValueHandler);
            return result;
        }
        throw new UnsupportedOperationException("Last accessor cannot be reverted because it's not " + ReversibleAccessor.class.getName() + ": " + lastAccessor);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof AccessorChain && this.accessors.equals(((AccessorChain)other).accessors);
    }

    @Override
    public int hashCode() {
        return this.accessors.hashCode();
    }

    @Override
    protected String getGetterDescription() {
        return this.accessors.toString();
    }

    public static class ValueInitializerOnNullValue
    implements NullValueHandler {
        private final BiFunction<Accessor, Class, Object> valueTypeDeterminer;

        public ValueInitializerOnNullValue() {
            this(null);
        }

        public ValueInitializerOnNullValue(@Nullable BiFunction<Accessor, Class, Object> valueTypeDeterminer) {
            this.valueTypeDeterminer = (BiFunction)Objects.preventNull(valueTypeDeterminer, ValueInitializerOnNullValue::newInstance);
        }

        @Override
        public Object consume(Object srcBean, Accessor accessor) {
            if (accessor instanceof ReversibleAccessor) {
                Mutator<Object, Object> mutator = ((ReversibleAccessor)accessor).toMutator();
                Class inputType = Accessors.giveInputType(mutator);
                Object value = this.valueTypeDeterminer.apply(accessor, inputType);
                mutator.set(srcBean, value);
                return value;
            }
            throw new UnsupportedOperationException("accessor cannot be reverted because it's not " + Reflections.toString(ReversibleAccessor.class) + ": " + accessor);
        }

        public static <T> T newInstance(Accessor<?, T> accessor, Class<T> valueType) {
            if (List.class.equals(valueType)) {
                return (T)new ArrayList();
            }
            if (SortedSet.class.equals(valueType)) {
                return (T)new TreeSet();
            }
            if (Set.class.equals(valueType)) {
                return (T)new HashSet();
            }
            if (SortedMap.class.equals(valueType)) {
                return (T)new TreeMap();
            }
            if (Map.class.equals(valueType)) {
                return (T)new HashMap();
            }
            if (BlockingDeque.class.equals(valueType)) {
                return (T)new LinkedBlockingDeque();
            }
            if (TransferQueue.class.equals(valueType)) {
                return (T)new LinkedTransferQueue();
            }
            if (BlockingQueue.class.equals(valueType)) {
                return (T)new ArrayBlockingQueue(16);
            }
            if (Queue.class.equals(valueType)) {
                return (T)new ArrayDeque();
            }
            return (T)Reflections.newInstance(valueType);
        }
    }

    private static class NullReturnerOnNullValue
    implements NullValueHandler {
        private NullReturnerOnNullValue() {
        }

        @Override
        public Object consume(Object srcBean, Accessor accessor) {
            return null;
        }
    }

    private static class NullPointerExceptionThrowerOnNullValue
    implements NullValueHandler {
        private NullPointerExceptionThrowerOnNullValue() {
        }

        @Override
        public Object consume(Object srcBean, Accessor accessor) {
            String accessorDescription = accessor.toString();
            String exceptionMessage = accessor instanceof AccessorByField ? srcBean + " has null value on field " + ((AccessorByField)accessor).getGetter().getName() : "Call of " + accessorDescription + " on " + srcBean + " returned null";
            throw new NullPointerException(exceptionMessage);
        }
    }

    public static interface NullValueHandler {
        public Object consume(Object var1, Accessor var2);
    }
}

